/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityProvider;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;

public final class SftpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    public static final ProxyType PROXY_HTTP = new ProxyType("http");
    public static final ProxyType PROXY_SOCKS5 = new ProxyType("socks");
    public static final ProxyType PROXY_STREAM = new ProxyType("stream");
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ZERO;
    private static final Duration DEFAULT_SESSION_TIMEOUT = Duration.ZERO;
    private static final String PREFIX = SftpFileSystemConfigBuilder.class.getName();
    private static final SftpFileSystemConfigBuilder BUILDER = new SftpFileSystemConfigBuilder();
    private static final String COMPRESSION = PREFIX + "COMPRESSION";
    private static final String CONNECT_TIMEOUT = PREFIX + ".CONNECT_TIMEOUT";
    private static final String ENCODING = PREFIX + ".ENCODING";
    private static final String HOST_KEY_CHECK_ASK = "ask";
    private static final String HOST_KEY_CHECK_NO = "no";
    private static final String HOST_KEY_CHECK_YES = "yes";
    private static final String IDENTITIES = PREFIX + ".IDENTITIES";
    private static final String IDENTITY_REPOSITORY_FACTORY = PREFIX + "IDENTITY_REPOSITORY_FACTORY";
    private static final String CONFIG_REPOSITORY = PREFIX + "CONFIG_REPOSITORY";
    private static final String KEY_EXCHANGE_ALGORITHM = PREFIX + ".KEY_EXCHANGE_ALGORITHM";
    private static final String LOAD_OPENSSH_CONFIG = PREFIX + "LOAD_OPENSSH_CONFIG";
    private static final String KNOWN_HOSTS = PREFIX + ".KNOWN_HOSTS";
    private static final String PREFERRED_AUTHENTICATIONS = PREFIX + ".PREFERRED_AUTHENTICATIONS";
    private static final String PROXY_COMMAND = PREFIX + ".PROXY_COMMAND";
    private static final String PROXY_HOST = PREFIX + ".PROXY_HOST";
    private static final String PROXY_OPTIONS = PREFIX + ".PROXY_OPTIONS";
    private static final String PROXY_PASSWORD = PREFIX + ".PROXY_PASSWORD";
    private static final String PROXY_PORT = PREFIX + ".PROXY_PORT";
    private static final String DISABLE_DETECT_EXEC_CHANNEL = PREFIX + ".DISABLE_DETECT_EXEC_CHANNEL";
    private static final String PROXY_TYPE = PREFIX + ".PROXY_TYPE";
    private static final String PROXY_USER = PREFIX + ".PROXY_USER";
    private static final String SESSION_TIMEOUT = PREFIX + ".TIMEOUT";
    private static final String STRICT_HOST_KEY_CHECKING = PREFIX + ".STRICT_HOST_KEY_CHECKING";
    private static final String USER_DIR_IS_ROOT = PREFIX + ".USER_DIR_IS_ROOT";

    public static SftpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private SftpFileSystemConfigBuilder() {
        super("sftp.");
    }

    public String getCompression(FileSystemOptions options) {
        return this.getString(options, COMPRESSION);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return SftpFileSystem.class;
    }

    public ConfigRepository getConfigRepository(FileSystemOptions options) {
        return (ConfigRepository)this.getParam(options, CONFIG_REPOSITORY);
    }

    public Duration getConnectTimeout(FileSystemOptions options) {
        return this.getDuration(options, CONNECT_TIMEOUT, DEFAULT_CONNECT_TIMEOUT);
    }

    @Deprecated
    public Integer getConnectTimeoutMillis(FileSystemOptions options) {
        return this.getDurationInteger(options, CONNECT_TIMEOUT, DEFAULT_CONNECT_TIMEOUT);
    }

    public String getFileNameEncoding(FileSystemOptions options) {
        return this.getString(options, ENCODING);
    }

    @Deprecated
    public File[] getIdentities(FileSystemOptions options) {
        IdentityInfo[] info = this.getIdentityInfo(options);
        if (info != null) {
            return (File[])Stream.of(info).map(IdentityInfo::getPrivateKey).toArray(File[]::new);
        }
        return null;
    }

    public IdentityInfo[] getIdentityInfo(FileSystemOptions options) {
        IdentityProvider[] infos = this.getIdentityProvider(options);
        if (infos != null) {
            return (IdentityInfo[])Stream.of(infos).filter(IdentityInfo.class::isInstance).map(info -> (IdentityInfo)info).toArray(IdentityInfo[]::new);
        }
        return null;
    }

    public IdentityProvider[] getIdentityProvider(FileSystemOptions options) {
        return (IdentityProvider[])this.getParam(options, IDENTITIES);
    }

    public IdentityRepositoryFactory getIdentityRepositoryFactory(FileSystemOptions options) {
        return (IdentityRepositoryFactory)this.getParam(options, IDENTITY_REPOSITORY_FACTORY);
    }

    public String getKeyExchangeAlgorithm(FileSystemOptions options) {
        return this.getString(options, KEY_EXCHANGE_ALGORITHM);
    }

    public File getKnownHosts(FileSystemOptions options) {
        return (File)this.getParam(options, KNOWN_HOSTS);
    }

    public String getPreferredAuthentications(FileSystemOptions options) {
        return this.getString(options, PREFERRED_AUTHENTICATIONS);
    }

    public String getProxyCommand(FileSystemOptions options) {
        return this.getString(options, PROXY_COMMAND, "nc -q 0 %s %d");
    }

    public String getProxyHost(FileSystemOptions options) {
        return this.getString(options, PROXY_HOST);
    }

    public FileSystemOptions getProxyOptions(FileSystemOptions options) {
        return (FileSystemOptions)this.getParam(options, PROXY_OPTIONS);
    }

    public String getProxyPassword(FileSystemOptions options) {
        return this.getString(options, PROXY_PASSWORD);
    }

    public int getProxyPort(FileSystemOptions options) {
        return this.getInteger(options, PROXY_PORT, 0);
    }

    public ProxyType getProxyType(FileSystemOptions options) {
        return (ProxyType)this.getParam(options, PROXY_TYPE);
    }

    public String getProxyUser(FileSystemOptions options) {
        return this.getString(options, PROXY_USER);
    }

    public Duration getSessionTimeout(FileSystemOptions options) {
        return this.getDuration(options, SESSION_TIMEOUT, DEFAULT_SESSION_TIMEOUT);
    }

    @Deprecated
    public Integer getSessionTimeoutMillis(FileSystemOptions options) {
        return this.getDurationInteger(options, SESSION_TIMEOUT, DEFAULT_SESSION_TIMEOUT);
    }

    public String getStrictHostKeyChecking(FileSystemOptions options) {
        return this.getString(options, STRICT_HOST_KEY_CHECKING, HOST_KEY_CHECK_NO);
    }

    @Deprecated
    public Integer getTimeout(FileSystemOptions options) {
        return this.getInteger(options, SESSION_TIMEOUT);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions options) {
        return this.getBoolean(options, USER_DIR_IS_ROOT, Boolean.TRUE);
    }

    public UserInfo getUserInfo(FileSystemOptions options) {
        return (UserInfo)this.getParam(options, UserInfo.class.getName());
    }

    public boolean isDisableDetectExecChannel(FileSystemOptions options) {
        return this.getBoolean(options, DISABLE_DETECT_EXEC_CHANNEL, Boolean.FALSE);
    }

    public boolean isLoadOpenSSHConfig(FileSystemOptions options) {
        return this.getBoolean(options, LOAD_OPENSSH_CONFIG, Boolean.FALSE);
    }

    public void setCompression(FileSystemOptions options, String compression) {
        this.setParam(options, COMPRESSION, compression);
    }

    public void setConfigRepository(FileSystemOptions options, ConfigRepository configRepository) {
        this.setParam(options, CONFIG_REPOSITORY, configRepository);
    }

    public void setConnectTimeout(FileSystemOptions options, Duration timeout) {
        this.setParam(options, CONNECT_TIMEOUT, timeout);
    }

    @Deprecated
    public void setConnectTimeoutMillis(FileSystemOptions options, Integer timeout) {
        this.setConnectTimeout(options, Duration.ofMillis(timeout.intValue()));
    }

    public void setDisableDetectExecChannel(FileSystemOptions options, boolean disableDetectExecChannel) {
        this.setParam(options, DISABLE_DETECT_EXEC_CHANNEL, this.toBooleanObject(disableDetectExecChannel));
    }

    public void setFileNameEncoding(FileSystemOptions options, String fileNameEncoding) {
        this.setParam(options, ENCODING, fileNameEncoding);
    }

    @Deprecated
    public void setIdentities(FileSystemOptions options, File ... identityFiles) {
        IdentityProvider[] info = null;
        if (identityFiles != null) {
            info = (IdentityProvider[])Stream.of(identityFiles).filter(Objects::nonNull).filter(Objects::nonNull).map(IdentityInfo::new).toArray(IdentityProvider[]::new);
        }
        this.setParam(options, IDENTITIES, info);
    }

    @Deprecated
    public void setIdentityInfo(FileSystemOptions options, IdentityInfo ... identities) {
        this.setParam(options, IDENTITIES, identities);
    }

    public void setIdentityProvider(FileSystemOptions options, IdentityProvider ... identities) {
        this.setParam(options, IDENTITIES, identities);
    }

    public void setIdentityRepositoryFactory(FileSystemOptions options, IdentityRepositoryFactory factory) {
        this.setParam(options, IDENTITY_REPOSITORY_FACTORY, factory);
    }

    public void setKeyExchangeAlgorithm(FileSystemOptions options, String keyExchangeAlgorithm) {
        this.setParam(options, KEY_EXCHANGE_ALGORITHM, keyExchangeAlgorithm);
    }

    public void setKnownHosts(FileSystemOptions options, File knownHosts) {
        this.setParam(options, KNOWN_HOSTS, knownHosts);
    }

    public void setLoadOpenSSHConfig(FileSystemOptions options, boolean loadOpenSSHConfig) {
        this.setParam(options, LOAD_OPENSSH_CONFIG, this.toBooleanObject(loadOpenSSHConfig));
    }

    public void setPreferredAuthentications(FileSystemOptions options, String preferredAuthentications) {
        this.setParam(options, PREFERRED_AUTHENTICATIONS, preferredAuthentications);
    }

    public void setProxyCommand(FileSystemOptions options, String proxyCommand) {
        this.setParam(options, PROXY_COMMAND, proxyCommand);
    }

    public void setProxyHost(FileSystemOptions options, String proxyHost) {
        this.setParam(options, PROXY_HOST, proxyHost);
    }

    public void setProxyOptions(FileSystemOptions options, FileSystemOptions proxyOptions) {
        this.setParam(options, PROXY_OPTIONS, proxyOptions);
    }

    public void setProxyPassword(FileSystemOptions options, String proxyPassword) {
        this.setParam(options, PROXY_PASSWORD, proxyPassword);
    }

    public void setProxyPort(FileSystemOptions options, int proxyPort) {
        this.setParam(options, PROXY_PORT, proxyPort);
    }

    public void setProxyType(FileSystemOptions options, ProxyType proxyType) {
        this.setParam(options, PROXY_TYPE, proxyType);
    }

    public void setProxyUser(FileSystemOptions options, String proxyUser) {
        this.setParam(options, PROXY_USER, proxyUser);
    }

    public void setSessionTimeout(FileSystemOptions options, Duration timeout) {
        this.setParam(options, SESSION_TIMEOUT, timeout);
    }

    @Deprecated
    public void setSessionTimeoutMillis(FileSystemOptions options, Integer timeout) {
        this.setSessionTimeout(options, Duration.ofMillis(timeout.intValue()));
    }

    public void setStrictHostKeyChecking(FileSystemOptions options, String hostKeyChecking) throws FileSystemException {
        if (hostKeyChecking == null || !hostKeyChecking.equals(HOST_KEY_CHECK_ASK) && !hostKeyChecking.equals(HOST_KEY_CHECK_NO) && !hostKeyChecking.equals(HOST_KEY_CHECK_YES)) {
            throw new FileSystemException("vfs.provider.sftp/StrictHostKeyChecking-arg.error", (Object)hostKeyChecking);
        }
        this.setParam(options, STRICT_HOST_KEY_CHECKING, hostKeyChecking);
    }

    @Deprecated
    public void setTimeout(FileSystemOptions options, Integer timeout) {
        this.setParam(options, SESSION_TIMEOUT, timeout);
    }

    public void setUserDirIsRoot(FileSystemOptions options, boolean userDirIsRoot) {
        this.setParam(options, USER_DIR_IS_ROOT, this.toBooleanObject(userDirIsRoot));
    }

    public void setUserInfo(FileSystemOptions options, UserInfo info) {
        this.setParam(options, UserInfo.class.getName(), info);
    }

    public static final class ProxyType
    implements Serializable,
    Comparable<ProxyType> {
        private static final long serialVersionUID = 20101208L;
        private final String proxyType;

        private ProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        @Override
        public int compareTo(ProxyType pType) {
            return this.proxyType.compareTo(pType.proxyType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equals(this.proxyType, ((ProxyType)obj).proxyType);
        }

        public int hashCode() {
            return this.proxyType.hashCode();
        }
    }
}

