/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs.config;

import lombok.Generated;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.vfs.gs.config.GoogleCloudConfig;
import org.apache.hop.vfs.gs.config.GoogleCloudConfigSingleton;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="GoogleCloudStorageConfigPlugin", description="Configuration options for Google Cloud", category="config")
@GuiPlugin(description="i18n::GoogleCloudPlugin.GuiPlugin.Description")
public class GoogleCloudConfigPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_ACCOUNT_KEY_FILE = "10000-google-cloud-service-account-key-file";
    @GuiWidgetElement(id="10000-google-cloud-service-account-key-file", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.FILENAME, variables=true, label="i18n::GoogleCloudPlugin.AccountKeyFile.Label", toolTip="i18n::GoogleCloudPlugin.AccountKeyFile.Description")
    @CommandLine.Option(names={"-gck", "--google-cloud-service-account-key-file"}, description={"Configure the path to a Google Cloud service account JSON key file"})
    private String serviceAccountKeyFile;

    public static GoogleCloudConfigPlugin getInstance() {
        GoogleCloudConfigPlugin instance = new GoogleCloudConfigPlugin();
        GoogleCloudConfig config = GoogleCloudConfigSingleton.getConfig();
        instance.serviceAccountKeyFile = config.getServiceAccountKeyFile();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        GoogleCloudConfig config = GoogleCloudConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.serviceAccountKeyFile != null) {
                config.setServiceAccountKeyFile(this.serviceAccountKeyFile);
                log.logBasic("The Google Cloud service account JSON jey file is set to '" + this.serviceAccountKeyFile + "'");
                changed = true;
            }
            if (changed) {
                GoogleCloudConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling Google Cloud configuration options", (Throwable)e);
        }
    }

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-google-cloud-service-account-key-file": {
                    this.serviceAccountKeyFile = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setServiceAccountKeyFile(this.serviceAccountKeyFile);
                }
            }
        }
        try {
            GoogleCloudConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving option", e);
        }
    }

    @Generated
    public void setServiceAccountKeyFile(String serviceAccountKeyFile) {
        this.serviceAccountKeyFile = serviceAccountKeyFile;
    }

    @Generated
    public String getServiceAccountKeyFile() {
        return this.serviceAccountKeyFile;
    }
}

