/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.KeyValueSet;
import org.apache.hop.core.util.PluginPropertyFactory;
import org.apache.hop.core.util.PluginPropertyHandler;
import org.apache.hop.core.util.StringPluginProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.w3c.dom.Node;

public abstract class AbstractTransformMeta<Main extends ITransform, Data extends ITransformData>
extends BaseTransformMeta<Main, Data> {
    private static final String CONNECTION_NAME = "connection";
    private final PluginPropertyFactory propertyFactory = new PluginPropertyFactory(new KeyValueSet());
    private DatabaseMeta dbMeta;
    private StringPluginProperty connectionName = this.propertyFactory.createString("connection");

    public PluginPropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public KeyValueSet getProperties() {
        return this.propertyFactory.getProperties();
    }

    public void saveAsPreferences() throws BackingStoreException {
        Preferences node = Preferences.userNodeForPackage(this.getClass());
        this.getProperties().walk(new PluginPropertyHandler.SaveToPreferences(node));
        node.flush();
    }

    public void readFromPreferences() {
        Preferences node = Preferences.userNodeForPackage(this.getClass());
        this.getProperties().walk(new PluginPropertyHandler.ReadFromPreferences(node));
    }

    public void loadXml(Node node, List<DatabaseMeta> databaseMeta, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.getProperties().walk(new PluginPropertyHandler.LoadXml(node));
        this.initDbMeta(databaseMeta);
    }

    private void initDbMeta(List<DatabaseMeta> databaseList) {
        if (!StringUtils.isEmpty((String)((String)this.connectionName.getValue()))) {
            this.dbMeta = DatabaseMeta.findDatabase(databaseList, (String)((String)this.connectionName.getValue()));
        }
    }

    @Override
    public String getXml() throws HopException {
        return PluginPropertyHandler.toXml(this.getProperties());
    }

    public StringPluginProperty getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(StringPluginProperty connectionName) {
        this.connectionName = connectionName;
    }

    public DatabaseMeta getDbMeta() {
        return this.dbMeta;
    }

    public void setDbMeta(DatabaseMeta dbMeta) {
        this.dbMeta = dbMeta;
    }
}

