/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupData;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupMeta;
import org.apache.hop.pipeline.transforms.databaselookup.DefaultCache;
import org.apache.hop.pipeline.transforms.databaselookup.KeyField;
import org.apache.hop.pipeline.transforms.databaselookup.Lookup;
import org.apache.hop.pipeline.transforms.databaselookup.ReturnValue;
import org.apache.hop.pipeline.transforms.databaselookup.readallcache.ReadAllCache;

public class DatabaseLookup
extends BaseTransform<DatabaseLookupMeta, DatabaseLookupData> {
    private static final Class<?> PKG = DatabaseLookupMeta.class;

    public DatabaseLookup(TransformMeta transformMeta, DatabaseLookupMeta meta, DatabaseLookupData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    @VisibleForTesting
    synchronized Object[] lookupValues(IRowMeta inputRowMeta, Object[] row) throws HopException {
        int i;
        Object[] add;
        Object[] outputRow = RowDataUtil.resizeArray((Object[])row, (int)((DatabaseLookupData)this.data).outputRowMeta.size());
        Object[] lookupRow = new Object[((DatabaseLookupData)this.data).lookupMeta.size()];
        int lookupIndex = 0;
        for (int i2 = 0; i2 < ((DatabaseLookupMeta)this.meta).getLookup().getKeyFields().size(); ++i2) {
            IValueMeta value;
            IValueMeta input;
            if (((DatabaseLookupData)this.data).keynrs[i2] >= 0) {
                input = inputRowMeta.getValueMeta(((DatabaseLookupData)this.data).keynrs[i2]);
                value = ((DatabaseLookupData)this.data).lookupMeta.getValueMeta(lookupIndex);
                lookupRow[lookupIndex] = row[((DatabaseLookupData)this.data).keynrs[i2]];
                if (input.getType() != value.getType() || 1 == input.getStorageType()) {
                    lookupRow[lookupIndex] = value.convertData(input, lookupRow[lookupIndex]);
                    value.setStorageType(0);
                }
                ++lookupIndex;
            }
            if (((DatabaseLookupData)this.data).keynrs2[i2] < 0) continue;
            input = inputRowMeta.getValueMeta(((DatabaseLookupData)this.data).keynrs2[i2]);
            value = ((DatabaseLookupData)this.data).lookupMeta.getValueMeta(lookupIndex);
            lookupRow[lookupIndex] = row[((DatabaseLookupData)this.data).keynrs2[i2]];
            if (input.getType() != value.getType() || 1 == input.getStorageType()) {
                lookupRow[lookupIndex] = value.convertData(input, lookupRow[lookupIndex]);
                value.setStorageType(0);
            }
            ++lookupIndex;
        }
        boolean cacheNow = false;
        boolean cacheHit = false;
        if (((DatabaseLookupMeta)this.meta).isCached()) {
            add = ((DatabaseLookupData)this.data).cache.getRowFromCache(((DatabaseLookupData)this.data).lookupMeta, lookupRow);
            if (add != null) {
                cacheHit = true;
            }
        } else {
            add = null;
        }
        if (!(add != null || ((DatabaseLookupMeta)this.meta).isCached() && ((DatabaseLookupMeta)this.meta).isLoadingAllDataInCache() && !((DatabaseLookupData)this.data).hasDBCondition)) {
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.AddedValuesToLookupRow1", (String[])new String[0]) + ((DatabaseLookupMeta)this.meta).getLookup().getKeyFields().size() + BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.AddedValuesToLookupRow2", (String[])new String[0]) + ((DatabaseLookupData)this.data).lookupMeta.getString(lookupRow));
            }
            ((DatabaseLookupData)this.data).db.setValuesLookup(((DatabaseLookupData)this.data).lookupMeta, lookupRow);
            add = ((DatabaseLookupData)this.data).db.getLookup(((DatabaseLookupMeta)this.meta).getLookup().isFailingOnMultipleResults());
            cacheNow = true;
        }
        if (add == null) {
            if (((DatabaseLookupMeta)this.meta).getLookup().isEatingRowOnLookupFailure()) {
                return null;
            }
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), row, 1L, "No lookup found", null, "DBL001");
                return null;
            }
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.NoResultsFoundAfterLookup", (String[])new String[0]));
            }
            add = new Object[((DatabaseLookupData)this.data).returnMeta.size()];
            for (i = 0; i < ((DatabaseLookupMeta)this.meta).getLookup().getReturnValues().size(); ++i) {
                add[i] = ((DatabaseLookupData)this.data).nullif[i] != null ? ((DatabaseLookupData)this.data).nullif[i] : null;
            }
        } else {
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.FoundResultsAfterLookup", (String[])new String[0]) + Arrays.toString(add));
            }
            for (int i3 : ((DatabaseLookupData)this.data).trimIndexes) {
                IValueMeta expected = ((DatabaseLookupData)this.data).returnMeta.getValueMeta(i3);
                add[i3] = expected.convertDataFromString((String)add[i3], expected, "", "", ValueMetaBase.getTrimTypeByCode((String)((DatabaseLookupData)this.data).returnTrimTypes[i3]));
            }
            if (!cacheHit) {
                this.incrementLinesInput();
                int[] types = ((DatabaseLookupData)this.data).returnValueTypes;
                for (int i3 = 0; i3 < types.length; ++i3) {
                    IValueMeta returned = ((DatabaseLookupData)this.data).db.getReturnRowMeta().getValueMeta(i3);
                    IValueMeta expected = ((DatabaseLookupData)this.data).returnMeta.getValueMeta(i3);
                    if (returned == null || types[i3] <= 0 || types[i3] == returned.getType()) continue;
                    add[i3] = expected.convertData(returned, add[i3]);
                }
            }
        }
        if (((DatabaseLookupMeta)this.meta).isCached() && cacheNow && !((DatabaseLookupMeta)this.meta).isLoadingAllDataInCache() && ((DatabaseLookupData)this.data).allEquals) {
            ((DatabaseLookupData)this.data).cache.storeRowInCache((DatabaseLookupMeta)this.meta, ((DatabaseLookupData)this.data).lookupMeta, lookupRow, add);
        }
        for (i = 0; i < ((DatabaseLookupData)this.data).returnMeta.size(); ++i) {
            outputRow[inputRowMeta.size() + i] = add[i];
        }
        return outputRow;
    }

    void determineFieldsTypesQueryingDb() throws HopException {
        List<KeyField> keyFields = ((DatabaseLookupMeta)this.meta).getLookup().getKeyFields();
        ((DatabaseLookupData)this.data).keytypes = new int[keyFields.size()];
        DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((DatabaseLookupMeta)this.meta).getConnection(), this.variables);
        String schemaTable = databaseMeta.getQuotedSchemaTableCombination((IVariables)this, ((DatabaseLookupMeta)this.meta).getSchemaName(), ((DatabaseLookupMeta)this.meta).getTableName());
        IRowMeta fields = ((DatabaseLookupData)this.data).db.getTableFields(schemaTable);
        if (fields != null) {
            for (int i = 0; i < keyFields.size(); ++i) {
                KeyField keyField = keyFields.get(i);
                IValueMeta key = fields.searchValueMeta(keyField.getTableField());
                if (key == null) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired5.Exception", (String[])new String[0]) + keyField.getTableField() + BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired6.Exception", (String[])new String[0]));
                }
                ((DatabaseLookupData)this.data).keytypes[i] = key.getType();
            }
        } else {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0002.UnableToDetermineFieldsOfTable", (String[])new String[0]) + schemaTable + "]");
        }
    }

    private void initNullIf() throws HopException {
        List<ReturnValue> returnValues = ((DatabaseLookupMeta)this.meta).getLookup().getReturnValues();
        ((DatabaseLookupData)this.data).nullif = new Object[returnValues.size()];
        for (int i = 0; i < returnValues.size(); ++i) {
            ReturnValue returnValue = returnValues.get(i);
            if (StringUtils.isNotEmpty((String)returnValue.getDefaultValue())) {
                ValueMetaString stringMeta = new ValueMetaString("string");
                IValueMeta returnMeta = ((DatabaseLookupData)this.data).outputRowMeta.getValueMeta(i + this.getInputRowMeta().size());
                ((DatabaseLookupData)this.data).nullif[i] = returnMeta.convertData((IValueMeta)stringMeta, (Object)returnValue.getDefaultValue());
                continue;
            }
            ((DatabaseLookupData)this.data).nullif[i] = null;
        }
    }

    private void initLookupMeta() throws HopException {
        ((DatabaseLookupData)this.data).lookupMeta = new RowMeta();
        List<KeyField> keyFields = ((DatabaseLookupMeta)this.meta).getLookup().getKeyFields();
        for (int i = 0; i < keyFields.size(); ++i) {
            IValueMeta value;
            IValueMeta inputValueMeta;
            if (((DatabaseLookupData)this.data).keynrs[i] >= 0) {
                inputValueMeta = this.getInputRowMeta().getValueMeta(((DatabaseLookupData)this.data).keynrs[i]);
                value = ValueMetaFactory.cloneValueMeta((IValueMeta)inputValueMeta, (int)((DatabaseLookupData)this.data).keytypes[i]);
                ((DatabaseLookupData)this.data).lookupMeta.addValueMeta(value);
            }
            if (((DatabaseLookupData)this.data).keynrs2[i] < 0) continue;
            inputValueMeta = this.getInputRowMeta().getValueMeta(((DatabaseLookupData)this.data).keynrs2[i]);
            value = ValueMetaFactory.cloneValueMeta((IValueMeta)inputValueMeta, (int)((DatabaseLookupData)this.data).keytypes[i]);
            ((DatabaseLookupData)this.data).lookupMeta.addValueMeta(value);
        }
    }

    private void initReturnMeta() {
        ((DatabaseLookupData)this.data).returnMeta = new RowMeta();
        List<ReturnValue> returnValues = ((DatabaseLookupMeta)this.meta).getLookup().getReturnValues();
        ((DatabaseLookupData)this.data).returnValueTypes = new int[returnValues.size()];
        for (int i = 0; i < returnValues.size(); ++i) {
            ((DatabaseLookupData)this.data).returnValueTypes[i] = ValueMetaFactory.getIdForValueMeta((String)returnValues.get(i).getDefaultType());
            IValueMeta v = ((DatabaseLookupData)this.data).outputRowMeta.getValueMeta(this.getInputRowMeta().size() + i).clone();
            ((DatabaseLookupData)this.data).returnMeta.addValueMeta(v);
        }
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            ((DatabaseLookupData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((DatabaseLookupMeta)this.meta).getFields(((DatabaseLookupData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            Lookup lookup = ((DatabaseLookupMeta)this.meta).getLookup();
            List<KeyField> keyFields = lookup.getKeyFields();
            List<ReturnValue> returnValues = lookup.getReturnValues();
            String[] keyField = new String[keyFields.size()];
            String[] keyCondition = new String[keyFields.size()];
            for (int i2 = 0; i2 < keyFields.size(); ++i2) {
                keyField[i2] = keyFields.get(i2).getTableField();
                keyCondition[i2] = keyFields.get(i2).getCondition();
            }
            String[] returnField = new String[returnValues.size()];
            String[] returnRename = new String[returnValues.size()];
            ((DatabaseLookupData)this.data).returnTrimTypes = new String[returnValues.size()];
            ((DatabaseLookupData)this.data).trimIndexes = new ArrayList<Integer>();
            for (i = 0; i < returnValues.size(); ++i) {
                returnField[i] = returnValues.get(i).getTableField();
                returnRename[i] = Utils.isEmpty((CharSequence)returnValues.get(i).getNewName()) ? null : returnValues.get(i).getNewName();
                ((DatabaseLookupData)this.data).returnTrimTypes[i] = returnValues.get(i).getTrimType();
            }
            ((DatabaseLookupData)this.data).db.setLookup(this.resolve(((DatabaseLookupMeta)this.meta).getSchemaName()), this.resolve(((DatabaseLookupMeta)this.meta).getTableName()), keyField, keyCondition, returnField, returnRename, lookup.getOrderByClause(), lookup.isFailingOnMultipleResults());
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
            }
            ((DatabaseLookupData)this.data).keynrs = new int[keyFields.size()];
            ((DatabaseLookupData)this.data).keynrs2 = new int[keyFields.size()];
            for (i = 0; i < keyFields.size(); ++i) {
                KeyField field = keyFields.get(i);
                ((DatabaseLookupData)this.data).keynrs[i] = this.getInputRowMeta().indexOfValue(field.getStreamField1());
                if (((DatabaseLookupData)this.data).keynrs[i] < 0 && !"IS NULL".equalsIgnoreCase(field.getCondition()) && !"IS NOT NULL".equalsIgnoreCase(field.getCondition())) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired1.Exception", (String[])new String[0]) + field.getStreamField1() + BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired2.Exception", (String[])new String[0]));
                }
                ((DatabaseLookupData)this.data).keynrs2[i] = this.getInputRowMeta().indexOfValue(field.getStreamField2());
                if (((DatabaseLookupData)this.data).keynrs2[i] < 0 && "BETWEEN".equalsIgnoreCase(field.getCondition())) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired3.Exception", (String[])new String[0]) + field.getStreamField2() + BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0001.FieldRequired4.Exception", (String[])new String[0]));
                }
                if (!this.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.FieldHasIndex1", (String[])new String[0]) + field.getStreamField1() + BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.FieldHasIndex2", (String[])new String[0]) + ((DatabaseLookupData)this.data).keynrs[i]);
            }
            if (((DatabaseLookupMeta)this.meta).isCached()) {
                ((DatabaseLookupData)this.data).cache = DefaultCache.newCache((DatabaseLookupData)this.data, ((DatabaseLookupMeta)this.meta).getCacheSize());
            }
            this.determineFieldsTypesQueryingDb();
            this.initNullIf();
            this.initLookupMeta();
            this.initReturnMeta();
            ((DatabaseLookupData)this.data).trimIndexes = new ArrayList<Integer>();
            for (i = 0; i < returnValues.size(); ++i) {
                if (((DatabaseLookupData)this.data).returnValueTypes[i] != 2 || ValueMetaBase.getTrimTypeByCode((String)((DatabaseLookupData)this.data).returnTrimTypes[i]) == 0) continue;
                ((DatabaseLookupData)this.data).trimIndexes.add(i);
            }
            if (((DatabaseLookupMeta)this.meta).isCached() && ((DatabaseLookupMeta)this.meta).isLoadingAllDataInCache()) {
                this.loadAllTableDataIntoTheCache();
            }
        }
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.GotRowFromPreviousTransform", (String[])new String[0]) + this.getInputRowMeta().getString(r));
        }
        try {
            Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
            if (outputRow != null) {
                this.putRow(((DatabaseLookupData)this.data).outputRowMeta, outputRow);
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.WroteRowToNextTransform", (String[])new String[0]) + this.getInputRowMeta().getString(r));
                }
                if (this.checkFeedback(this.getLinesRead())) {
                    this.logBasic("linenr " + this.getLinesRead());
                }
            }
        }
        catch (HopException e) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), null, "DBLOOKUPD001");
            }
            this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR003.UnexpectedErrorDuringProcessing", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void loadAllTableDataIntoTheCache() throws HopException {
        DatabaseMeta dbMeta = this.getPipelineMeta().findDatabase(((DatabaseLookupMeta)this.meta).getConnection(), this.variables);
        Database db = this.getDatabase(dbMeta);
        this.connectDatabase(db);
        Lookup lookup = ((DatabaseLookupMeta)this.meta).getLookup();
        try {
            List rows;
            Object sql = "SELECT ";
            List<KeyField> keyFields = lookup.getKeyFields();
            for (int i = 0; i < keyFields.size(); ++i) {
                KeyField keyField = keyFields.get(i);
                if (i > 0) {
                    sql = (String)sql + ", ";
                }
                sql = (String)sql + dbMeta.quoteField(keyField.getTableField());
            }
            List<ReturnValue> returnValues = lookup.getReturnValues();
            for (int i = 0; i < returnValues.size(); ++i) {
                ReturnValue returnValue = returnValues.get(i);
                sql = (String)sql + ", " + dbMeta.quoteField(returnValue.getTableField());
            }
            sql = (String)sql + " FROM " + dbMeta.getQuotedSchemaTableCombination((IVariables)this, ((DatabaseLookupMeta)this.meta).getSchemaName(), ((DatabaseLookupMeta)this.meta).getTableName());
            if (StringUtils.isNotEmpty((String)lookup.getOrderByClause())) {
                sql = (String)sql + " ORDER BY " + lookup.getOrderByClause();
            }
            if ((rows = db.getRows((String)sql, 0)) != null && !rows.isEmpty()) {
                if (((DatabaseLookupData)this.data).allEquals) {
                    this.putToDefaultCache(db, rows);
                } else {
                    this.putToReadOnlyCache(db, rows);
                }
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            if (db != null) {
                db.disconnect();
            }
        }
    }

    private void putToDefaultCache(Database db, List<Object[]> rows) {
        int keysAmount = ((DatabaseLookupMeta)this.meta).getLookup().getKeyFields().size();
        IRowMeta prototype = this.copyValueMetasFrom(db.getReturnRowMeta(), keysAmount);
        for (Object[] row : rows) {
            int index = 0;
            IRowMeta keyMeta = prototype.clone();
            Object[] keyData = new Object[keysAmount];
            for (int i = 0; i < keysAmount; ++i) {
                keyData[i] = row[index++];
            }
            Object[] valueData = new Object[((DatabaseLookupData)this.data).returnMeta.size()];
            for (int i = 0; i < ((DatabaseLookupData)this.data).returnMeta.size(); ++i) {
                valueData[i] = row[index++];
            }
            ((DatabaseLookupData)this.data).cache.storeRowInCache((DatabaseLookupMeta)this.meta, keyMeta, keyData, valueData);
            this.incrementLinesInput();
        }
    }

    private IRowMeta copyValueMetasFrom(IRowMeta source, int n) {
        RowMeta result = new RowMeta();
        for (int i = 0; i < n; ++i) {
            result.addValueMeta(source.getValueMeta(i));
        }
        return result;
    }

    private void putToReadOnlyCache(Database db, List<Object[]> rows) {
        ReadAllCache.Builder cacheBuilder = new ReadAllCache.Builder((DatabaseLookupData)this.data, rows.size());
        IRowMeta returnRowMeta = db.getReturnRowMeta();
        cacheBuilder.setKeysMeta(returnRowMeta.clone());
        int keysAmount = ((DatabaseLookupMeta)this.meta).getLookup().getKeyFields().size();
        int valuesAmount = ((DatabaseLookupData)this.data).returnMeta.size();
        for (Object[] row : rows) {
            Object[] keyData = new Object[keysAmount];
            System.arraycopy(row, 0, keyData, 0, keysAmount);
            Object[] valueData = new Object[valuesAmount];
            System.arraycopy(row, keysAmount, valueData, 0, valuesAmount);
            cacheBuilder.add(keyData, valueData);
            this.incrementLinesInput();
        }
        ((DatabaseLookupData)this.data).cache = cacheBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() throws HopException {
        if (((DatabaseLookupData)this.data).db != null && !((DatabaseLookupData)this.data).isCanceled) {
            Database database = ((DatabaseLookupData)this.data).db;
            synchronized (database) {
                ((DatabaseLookupData)this.data).db.cancelQuery();
            }
            ((DatabaseLookupData)this.data).isCanceled = true;
        }
    }

    public boolean init() {
        block6: {
            if (super.init()) {
                if (Utils.isEmpty((CharSequence)((DatabaseLookupMeta)this.meta).getConnection())) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookup.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((DatabaseLookupMeta)this.meta).getConnection(), this.variables);
                ((DatabaseLookupData)this.data).db = this.getDatabase(databaseMeta);
                try {
                    this.connectDatabase(((DatabaseLookupData)this.data).db);
                    Lookup lookup = ((DatabaseLookupMeta)this.meta).getLookup();
                    List<KeyField> keyFields = lookup.getKeyFields();
                    ((DatabaseLookupData)this.data).allEquals = true;
                    ((DatabaseLookupData)this.data).hasDBCondition = false;
                    ((DatabaseLookupData)this.data).conditions = new int[keyFields.size()];
                    for (int i = 0; i < keyFields.size(); ++i) {
                        KeyField keyField = keyFields.get(i);
                        ((DatabaseLookupData)this.data).conditions[i] = Const.indexOfString((String)keyField.getCondition(), (String[])DatabaseLookupMeta.conditionStrings);
                        if (!"=".equals(keyField.getCondition()) && !"IS NULL".equalsIgnoreCase(keyField.getCondition())) {
                            ((DatabaseLookupData)this.data).allEquals = false;
                        }
                        if (((DatabaseLookupData)this.data).conditions[i] != 6) continue;
                        ((DatabaseLookupData)this.data).hasDBCondition = true;
                    }
                    return true;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookup.ERROR0004.UnexpectedErrorDuringInit", (String[])new String[0]) + String.valueOf(e));
                    if (((DatabaseLookupData)this.data).db == null) break block6;
                    ((DatabaseLookupData)this.data).db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose() {
        if (((DatabaseLookupData)this.data).db != null) {
            ((DatabaseLookupData)this.data).db.disconnect();
        }
        ((DatabaseLookupData)this.data).cache = null;
        ((DatabaseLookupData)this.data).db = null;
        super.dispose();
    }

    Database getDatabase(DatabaseMeta meta) {
        return new Database((ILoggingObject)this, (IVariables)this, meta);
    }

    private void connectDatabase(Database database) throws HopDatabaseException {
        database.connect();
        database.setCommit(100);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseLookup.Log.ConnectedToDatabase", (String[])new String[0]));
        }
    }
}

