/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.patch;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.extension.PatchResourceService;
import org.apache.guacamole.resource.Resource;

@Path(value="/patches")
@Produces(value={"application/json"})
public class PatchRESTService {
    @Inject
    private PatchResourceService patchResourceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResourceAsString(Resource resource) throws IOException {
        StringBuilder contents = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(resource.asStream(), "UTF-8");){
            int length;
            char[] buffer = new char[8192];
            while ((length = reader.read(buffer)) != -1) {
                contents.append(buffer, 0, length);
            }
        }
        return contents.toString();
    }

    @GET
    public List<String> getPatches() throws GuacamoleException {
        try {
            List resources = this.patchResourceService.getPatchResources();
            ArrayList<String> patches = new ArrayList<String>(resources.size());
            for (Resource resource : resources) {
                patches.add(this.readResourceAsString(resource));
            }
            return patches;
        }
        catch (IOException e) {
            throw new GuacamoleServerException("Unable to read HTML patches.", (Throwable)e);
        }
    }
}

