/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import java.util.ArrayList;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.common.spi.Lifecycle;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.apache.groovy.contracts.util.LifecycleImplementationLoader;
import org.apache.groovy.contracts.util.Validate;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;

public class LifecycleBeforeTransformationVisitor
extends BaseVisitor {
    private final ProcessingContextInformation pci;

    public LifecycleBeforeTransformationVisitor(SourceUnit sourceUnit, ReaderSource source, ProcessingContextInformation pci) {
        super(sourceUnit, source);
        Validate.notNull(pci);
        this.pci = pci;
    }

    public void visitClass(ClassNode node) {
        super.visitClass(node);
        ArrayList methods = new ArrayList(node.getMethods());
        ArrayList constructors = new ArrayList(node.getDeclaredConstructors());
        for (Lifecycle lifecyle : LifecycleImplementationLoader.load(Lifecycle.class, ((Object)((Object)this)).getClass().getClassLoader())) {
            lifecyle.beforeProcessingClassNode(this.pci, node);
            for (MethodNode constructor : constructors) {
                lifecyle.beforeProcessingConstructorNode(this.pci, node, constructor);
            }
            for (MethodNode method : methods) {
                lifecyle.beforeProcessingMethodNode(this.pci, node, method);
            }
        }
    }
}

