/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.geronimo.connector.mock;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.LocalTransaction;

/**
 *
 *
 * @version $Rev$ $Date$
 *
 * */
public class MockSPILocalTransaction implements LocalTransaction {


    private boolean inTransaction;
    private boolean begun;
    private boolean committed;
    private boolean rolledBack;

    public MockSPILocalTransaction() {
    }

    public void begin() throws ResourceException {
        assert !inTransaction;
        inTransaction = true;
        begun = true;
    }

    public void commit() throws ResourceException {
        assert inTransaction;
        inTransaction = false;
        committed = true;
    }

    public void rollback() throws ResourceException {
        assert inTransaction;
        inTransaction = false;
        rolledBack = true;
    }

    public void reset() {
        inTransaction = false;
        begun = false;
        committed = false;
        rolledBack = false;
    }

    public boolean isInTransaction() {
        return inTransaction;
    }

    public boolean isBegun() {
        return begun;
    }

    public boolean isCommitted() {
        return committed;
    }

    public boolean isRolledBack() {
        return rolledBack;
    }
}
