/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.EncodingAware;
import javax.mail.MessagingException;
import javax.mail.internet.ContentCheckingOutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.geronimo.mail.util.ASCIIUtil;
import org.apache.geronimo.mail.util.Base64;
import org.apache.geronimo.mail.util.Base64DecoderStream;
import org.apache.geronimo.mail.util.Base64Encoder;
import org.apache.geronimo.mail.util.Base64EncoderStream;
import org.apache.geronimo.mail.util.QuotedPrintableDecoderStream;
import org.apache.geronimo.mail.util.QuotedPrintableEncoder;
import org.apache.geronimo.mail.util.QuotedPrintableEncoderStream;
import org.apache.geronimo.mail.util.SessionUtil;
import org.apache.geronimo.mail.util.UUDecoderStream;
import org.apache.geronimo.mail.util.UUEncoderStream;

public class MimeUtility {
    private static final String MIME_FOLDENCODEDWORDS = "mail.mime.foldencodedwords";
    private static final String MIME_DECODE_TEXT_STRICT = "mail.mime.decodetext.strict";
    private static final String MIME_FOLDTEXT = "mail.mime.foldtext";
    private static final int FOLD_THRESHOLD = 76;
    static final int ALL_ASCII = 1;
    static final int MOSTLY_ASCII = 2;
    static final int MOSTLY_NONASCII = 3;
    public static final int ALL = -1;
    private static String escapedChars = "\"\\\r\n";
    private static String linearWhiteSpace = " \t\r\n";
    private static String QP_WORD_SPECIALS = "=_?\"#$%&'(),.:;<>@[\\]^`{|}~";
    private static String QP_TEXT_SPECIALS = "=_?";
    private static Map java2mime;
    private static Map mime2java;

    private MimeUtility() {
    }

    public static InputStream decode(InputStream in, String encoding) throws MessagingException {
        if ((encoding = encoding.toLowerCase()).equals("binary") || encoding.equals("7bit") || encoding.equals("8bit")) {
            return in;
        }
        if (encoding.equals("base64")) {
            return new Base64DecoderStream(in);
        }
        if (encoding.equals("uuencode") || encoding.equals("x-uuencode") || encoding.equals("x-uue")) {
            return new UUDecoderStream(in);
        }
        if (encoding.equals("quoted-printable")) {
            return new QuotedPrintableDecoderStream(in);
        }
        throw new MessagingException("Unknown encoding " + encoding);
    }

    public static String decodeText(String text) throws UnsupportedEncodingException {
        if (text.indexOf("=?") < 0) {
            return text;
        }
        if (!SessionUtil.getBooleanProperty(MIME_DECODE_TEXT_STRICT, true)) {
            return MimeUtility.decodeTextNonStrict(text);
        }
        int offset = 0;
        int endOffset = text.length();
        int startWhiteSpace = -1;
        int endWhiteSpace = -1;
        StringBuffer decodedText = new StringBuffer(text.length());
        boolean previousTokenEncoded = false;
        block2: while (offset < endOffset) {
            char ch = text.charAt(offset);
            if (linearWhiteSpace.indexOf(ch) != -1) {
                startWhiteSpace = offset;
                while (offset < endOffset) {
                    ch = text.charAt(offset);
                    if (linearWhiteSpace.indexOf(ch) != -1) {
                        ++offset;
                        continue;
                    }
                    endWhiteSpace = offset;
                    continue block2;
                }
                continue;
            }
            int wordStart = offset;
            while (offset < endOffset && linearWhiteSpace.indexOf(ch = text.charAt(offset)) == -1) {
                ++offset;
            }
            String word = text.substring(wordStart, offset);
            if (word.startsWith("=?")) {
                try {
                    String decodedWord = MimeUtility.decodeWord(word);
                    if (!previousTokenEncoded && startWhiteSpace != -1) {
                        decodedText.append(text.substring(startWhiteSpace, endWhiteSpace));
                        startWhiteSpace = -1;
                    }
                    previousTokenEncoded = true;
                    decodedText.append(decodedWord);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (startWhiteSpace != -1) {
                decodedText.append(text.substring(startWhiteSpace, endWhiteSpace));
                startWhiteSpace = -1;
            }
            previousTokenEncoded = false;
            decodedText.append(word);
        }
        return decodedText.toString();
    }

    private static String decodeTextNonStrict(String text) throws UnsupportedEncodingException {
        int offset = 0;
        int endOffset = text.length();
        int startWhiteSpace = -1;
        int endWhiteSpace = -1;
        StringBuffer decodedText = new StringBuffer(text.length());
        boolean previousTokenEncoded = false;
        block2: while (offset < endOffset) {
            char ch = text.charAt(offset);
            if (linearWhiteSpace.indexOf(ch) != -1) {
                startWhiteSpace = offset;
                while (offset < endOffset) {
                    ch = text.charAt(offset);
                    if (linearWhiteSpace.indexOf(ch) != -1) {
                        ++offset;
                        continue;
                    }
                    endWhiteSpace = offset;
                    continue block2;
                }
                continue;
            }
            int wordStart = offset;
            while (offset < endOffset && linearWhiteSpace.indexOf(ch = text.charAt(offset)) == -1) {
                ++offset;
            }
            String word = text.substring(wordStart, offset);
            int decodeStart = 0;
            while (decodeStart < word.length()) {
                int tokenEnd;
                int tokenStart = word.indexOf("=?", decodeStart);
                if (tokenStart == -1) {
                    if (startWhiteSpace != -1) {
                        decodedText.append(text.substring(startWhiteSpace, endWhiteSpace));
                        startWhiteSpace = -1;
                    }
                    previousTokenEncoded = false;
                    decodedText.append(word.substring(decodeStart));
                    continue block2;
                }
                if (tokenStart != decodeStart) {
                    if (startWhiteSpace != -1) {
                        decodedText.append(text.substring(startWhiteSpace, endWhiteSpace));
                        startWhiteSpace = -1;
                    }
                    previousTokenEncoded = false;
                    decodedText.append(word.substring(decodeStart, tokenStart));
                }
                if ((tokenEnd = word.indexOf("?=", tokenStart)) == -1) {
                    if (startWhiteSpace != -1) {
                        decodedText.append(text.substring(startWhiteSpace, endWhiteSpace));
                        startWhiteSpace = -1;
                    }
                    previousTokenEncoded = false;
                    decodedText.append(word.substring(tokenStart));
                    continue block2;
                }
                decodeStart = tokenEnd + 2;
                String token = word.substring(tokenStart, tokenEnd);
                try {
                    String decodedWord = MimeUtility.decodeWord(token);
                    if (!previousTokenEncoded && startWhiteSpace != -1) {
                        decodedText.append(text.substring(startWhiteSpace, endWhiteSpace));
                        startWhiteSpace = -1;
                    }
                    previousTokenEncoded = true;
                    decodedText.append(decodedWord);
                }
                catch (ParseException parseException) {
                    if (startWhiteSpace != -1) {
                        decodedText.append(text.substring(startWhiteSpace, endWhiteSpace));
                        startWhiteSpace = -1;
                    }
                    previousTokenEncoded = false;
                    decodedText.append(token);
                }
            }
        }
        return decodedText.toString();
    }

    public static String decodeWord(String word) throws ParseException, UnsupportedEncodingException {
        if (!word.startsWith("=?")) {
            throw new ParseException("Invalid RFC 2047 encoded-word: " + word);
        }
        int charsetPos = word.indexOf(63, 2);
        if (charsetPos == -1) {
            throw new ParseException("Missing charset in RFC 2047 encoded-word: " + word);
        }
        String charset = word.substring(2, charsetPos).toLowerCase();
        int encodingPos = word.indexOf(63, charsetPos + 1);
        if (encodingPos == -1) {
            throw new ParseException("Missing encoding in RFC 2047 encoded-word: " + word);
        }
        String encoding = word.substring(charsetPos + 1, encodingPos);
        int encodedTextPos = word.indexOf("?=", encodingPos + 1);
        if (encodedTextPos == -1) {
            throw new ParseException("Missing encoded text in RFC 2047 encoded-word: " + word);
        }
        String encodedText = word.substring(encodingPos + 1, encodedTextPos);
        if (encodedText.length() == 0) {
            return "";
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(encodedText.length());
            byte[] encodedData = encodedText.getBytes("US-ASCII");
            if (encoding.equals("B")) {
                Base64.decode(encodedData, (OutputStream)out);
            } else if (encoding.equals("Q")) {
                QuotedPrintableEncoder dataEncoder = new QuotedPrintableEncoder();
                dataEncoder.decodeWord(encodedData, out);
            } else {
                throw new UnsupportedEncodingException("Unknown RFC 2047 encoding: " + encoding);
            }
            byte[] decodedData = out.toByteArray();
            return new String(decodedData, MimeUtility.javaCharset(charset));
        }
        catch (IOException e) {
            throw new UnsupportedEncodingException("Invalid RFC 2047 encoding");
        }
    }

    public static OutputStream encode(OutputStream out, String encoding) throws MessagingException {
        if (encoding == null) {
            return out;
        }
        if ((encoding = encoding.toLowerCase()).equals("binary") || encoding.equals("7bit") || encoding.equals("8bit")) {
            return out;
        }
        if (encoding.equals("base64")) {
            return new Base64EncoderStream(out);
        }
        if (encoding.equals("uuencode") || encoding.equals("x-uuencode") || encoding.equals("x-uue")) {
            return new UUEncoderStream(out);
        }
        if (encoding.equals("quoted-printable")) {
            return new QuotedPrintableEncoderStream(out);
        }
        throw new MessagingException("Unknown encoding " + encoding);
    }

    public static OutputStream encode(OutputStream out, String encoding, String filename) throws MessagingException {
        if ((encoding = encoding.toLowerCase()).equals("binary") || encoding.equals("7bit") || encoding.equals("8bit")) {
            return out;
        }
        if (encoding.equals("base64")) {
            return new Base64EncoderStream(out);
        }
        if (encoding.equals("uuencode") || encoding.equals("x-uuencode") || encoding.equals("x-uue")) {
            return new UUEncoderStream(out, filename);
        }
        if (encoding.equals("quoted-printable")) {
            return new QuotedPrintableEncoderStream(out);
        }
        throw new MessagingException("Unknown encoding " + encoding);
    }

    public static String encodeText(String word) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(word, null, null);
    }

    public static String encodeText(String word, String charset, String encoding) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, charset, encoding, false);
    }

    public static String encodeWord(String word) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, null, null);
    }

    public static String encodeWord(String word, String charset, String encoding) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(word, charset, encoding, true);
    }

    private static String encodeWord(String word, String charset, String encoding, boolean encodingWord) throws UnsupportedEncodingException {
        String encoder = ASCIIUtil.getTextTransferEncoding(word);
        if (encoder.equals("7bit")) {
            return word;
        }
        if (charset == null) {
            charset = MimeUtility.getDefaultMIMECharset();
        }
        if (encoding != null) {
            if (encoding.equalsIgnoreCase("B")) {
                encoder = "base64";
            } else if (encoding.equalsIgnoreCase("Q")) {
                encoder = "quoted-printable";
            } else {
                throw new UnsupportedEncodingException("Unknown transfer encoding: " + encoding);
            }
        }
        try {
            StringBuffer result = new StringBuffer();
            int sizeLimit = 68 - charset.length();
            if (encoder.equals("base64")) {
                Base64Encoder dataEncoder = new Base64Encoder();
                MimeUtility.encodeBase64(word, result, sizeLimit, charset, dataEncoder, true, SessionUtil.getBooleanProperty(MIME_FOLDENCODEDWORDS, false));
            } else {
                QuotedPrintableEncoder dataEncoder = new QuotedPrintableEncoder();
                MimeUtility.encodeQuotedPrintable(word, result, sizeLimit, charset, dataEncoder, true, SessionUtil.getBooleanProperty(MIME_FOLDENCODEDWORDS, false), encodingWord ? QP_WORD_SPECIALS : QP_TEXT_SPECIALS);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new UnsupportedEncodingException("Invalid encoding");
        }
    }

    private static void encodeBase64(String data, StringBuffer out, int sizeLimit, String charset, Base64Encoder encoder, boolean firstSegment, boolean foldSegments) throws IOException {
        byte[] bytes = data.getBytes(MimeUtility.javaCharset(charset));
        int estimatedSize = encoder.estimateEncodedLength(bytes);
        if (estimatedSize > sizeLimit) {
            MimeUtility.encodeBase64(data.substring(0, data.length() / 2), out, sizeLimit, charset, encoder, firstSegment, foldSegments);
            MimeUtility.encodeBase64(data.substring(data.length() / 2), out, sizeLimit, charset, encoder, false, foldSegments);
        } else {
            if (!firstSegment) {
                if (foldSegments) {
                    out.append("\r\n");
                } else {
                    out.append(' ');
                }
            }
            encoder.encodeWord(bytes, out, charset);
        }
    }

    private static void encodeQuotedPrintable(String data, StringBuffer out, int sizeLimit, String charset, QuotedPrintableEncoder encoder, boolean firstSegment, boolean foldSegments, String specials) throws IOException {
        byte[] bytes = data.getBytes(MimeUtility.javaCharset(charset));
        int estimatedSize = encoder.estimateEncodedLength(bytes, specials);
        if (estimatedSize > sizeLimit) {
            MimeUtility.encodeQuotedPrintable(data.substring(0, data.length() / 2), out, sizeLimit, charset, encoder, firstSegment, foldSegments, specials);
            MimeUtility.encodeQuotedPrintable(data.substring(data.length() / 2), out, sizeLimit, charset, encoder, false, foldSegments, specials);
        } else {
            if (!firstSegment) {
                if (foldSegments) {
                    out.append("\r\n");
                } else {
                    out.append(' ');
                }
            }
            encoder.encodeWord(bytes, out, charset, specials);
        }
    }

    public static String getEncoding(DataHandler handler) {
        DataSource ds = handler.getDataSource();
        if (ds != null) {
            return MimeUtility.getEncoding(ds);
        }
        try {
            ContentType content = new ContentType(handler.getContentType());
            ContentCheckingOutputStream checker = new ContentCheckingOutputStream();
            handler.writeTo((OutputStream)checker);
            if (content.match("text/*")) {
                return checker.getTextTransferEncoding();
            }
            return checker.getBinaryTransferEncoding();
        }
        catch (Exception e) {
            return "base64";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncoding(DataSource source) {
        String string;
        String encoding;
        if (source instanceof EncodingAware && (encoding = ((EncodingAware)source).getEncoding()) != null) {
            return encoding;
        }
        InputStream in = null;
        try {
            ContentType content = new ContentType(source.getContentType());
            in = source.getInputStream();
            if (!content.match("text/*")) {
                String string2 = ASCIIUtil.getBinaryTransferEncoding(in);
                return string2;
            }
            string = ASCIIUtil.getTextTransferEncoding(in);
        }
        catch (Exception e) {
            String string3 = "base64";
            return string3;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static String quote(String word, String specials) {
        int wordLength = word.length();
        for (int i = 0; i < wordLength; ++i) {
            char ch = word.charAt(i);
            if (escapedChars.indexOf(ch) >= 0) {
                return MimeUtility.quoteAndEscapeString(word);
            }
            if (ch >= ' ' && ch < '\u007f' && specials.indexOf(ch) < 0) continue;
            return MimeUtility.quoteAndEscapeString(word);
        }
        return word;
    }

    private static String quoteAndEscapeString(String word) {
        int wordLength = word.length();
        StringBuffer buffer = new StringBuffer(wordLength + 10);
        buffer.append('\"');
        for (int i = 0; i < wordLength; ++i) {
            char ch = word.charAt(i);
            if (escapedChars.indexOf(ch) >= 0) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static String javaCharset(String charset) {
        if (charset == null) {
            return null;
        }
        String mappedCharset = (String)mime2java.get(charset.toLowerCase());
        return mappedCharset == null ? charset : mappedCharset;
    }

    public static String mimeCharset(String charset) {
        if (charset == null) {
            return null;
        }
        String mappedCharset = (String)java2mime.get(charset.toLowerCase());
        return mappedCharset == null ? charset : mappedCharset;
    }

    public static String getDefaultJavaCharset() {
        String charset = SessionUtil.getProperty("mail.mime.charset");
        if (charset != null) {
            return MimeUtility.javaCharset(charset);
        }
        return SessionUtil.getProperty("file.encoding", "8859_1");
    }

    static String getDefaultMIMECharset() {
        String charset = SessionUtil.getProperty("mail.mime.charset");
        if (charset != null) {
            return charset;
        }
        return MimeUtility.mimeCharset(SessionUtil.getProperty("file.encoding", "8859_1"));
    }

    private static void loadCharacterSetMappings() {
        java2mime = new HashMap();
        mime2java = new HashMap();
        try {
            InputStream map = MimeUtility.class.getResourceAsStream("/META-INF/javamail.charset.map");
            if (map != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(map));
                MimeUtility.readMappings(reader, java2mime);
                MimeUtility.readMappings(reader, mime2java);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (java2mime.isEmpty()) {
            java2mime.put("8859_1", "ISO-8859-1");
            java2mime.put("iso8859_1", "ISO-8859-1");
            java2mime.put("iso8859-1", "ISO-8859-1");
            java2mime.put("8859_2", "ISO-8859-2");
            java2mime.put("iso8859_2", "ISO-8859-2");
            java2mime.put("iso8859-2", "ISO-8859-2");
            java2mime.put("8859_3", "ISO-8859-3");
            java2mime.put("iso8859_3", "ISO-8859-3");
            java2mime.put("iso8859-3", "ISO-8859-3");
            java2mime.put("8859_4", "ISO-8859-4");
            java2mime.put("iso8859_4", "ISO-8859-4");
            java2mime.put("iso8859-4", "ISO-8859-4");
            java2mime.put("8859_5", "ISO-8859-5");
            java2mime.put("iso8859_5", "ISO-8859-5");
            java2mime.put("iso8859-5", "ISO-8859-5");
            java2mime.put("8859_6", "ISO-8859-6");
            java2mime.put("iso8859_6", "ISO-8859-6");
            java2mime.put("iso8859-6", "ISO-8859-6");
            java2mime.put("8859_7", "ISO-8859-7");
            java2mime.put("iso8859_7", "ISO-8859-7");
            java2mime.put("iso8859-7", "ISO-8859-7");
            java2mime.put("8859_8", "ISO-8859-8");
            java2mime.put("iso8859_8", "ISO-8859-8");
            java2mime.put("iso8859-8", "ISO-8859-8");
            java2mime.put("8859_9", "ISO-8859-9");
            java2mime.put("iso8859_9", "ISO-8859-9");
            java2mime.put("iso8859-9", "ISO-8859-9");
            java2mime.put("sjis", "Shift_JIS");
            java2mime.put("jis", "ISO-2022-JP");
            java2mime.put("iso2022jp", "ISO-2022-JP");
            java2mime.put("euc_jp", "euc-jp");
            java2mime.put("koi8_r", "koi8-r");
            java2mime.put("euc_cn", "euc-cn");
            java2mime.put("euc_tw", "euc-tw");
            java2mime.put("euc_kr", "euc-kr");
        }
        if (mime2java.isEmpty()) {
            mime2java.put("iso-2022-cn", "ISO2022CN");
            mime2java.put("iso-2022-kr", "ISO2022KR");
            mime2java.put("utf-8", "UTF8");
            mime2java.put("utf8", "UTF8");
            mime2java.put("ja_jp.iso2022-7", "ISO2022JP");
            mime2java.put("ja_jp.eucjp", "EUCJIS");
            mime2java.put("euc-kr", "KSC5601");
            mime2java.put("euckr", "KSC5601");
            mime2java.put("us-ascii", "ISO-8859-1");
            mime2java.put("x-us-ascii", "ISO-8859-1");
        }
    }

    private static void readMappings(BufferedReader reader, Map table) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("--") && line.endsWith("--")) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(line, " \t");
            try {
                String from = tokenizer.nextToken().toLowerCase();
                String to = tokenizer.nextToken();
                table.put(from, to);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
        return;
    }

    public static String fold(int used, String s) {
        char ch;
        int end;
        if (!SessionUtil.getBooleanProperty(MIME_FOLDTEXT, true)) {
            return s;
        }
        for (end = s.length() - 1; end >= 0 && ((ch = s.charAt(end)) == ' ' || ch == '\t'); --end) {
        }
        if (end != s.length() - 1) {
            s = s.substring(0, end + 1);
        }
        if (s.length() + used <= 76) {
            return s;
        }
        StringBuffer newString = new StringBuffer(s.length() + 8);
        while (used + s.length() > 76) {
            int breakPoint = -1;
            char breakChar = '\u0000';
            for (int i = 0; i < s.length() && (used + i <= 76 || breakPoint == -1); ++i) {
                char ch2 = s.charAt(i);
                if (ch2 == ' ' || ch2 == '\t') {
                    breakPoint = i++;
                    breakChar = ch2;
                    while (i < s.length() && ((ch2 = s.charAt(i)) == ' ' || ch2 == '\t')) {
                        ++i;
                    }
                    continue;
                }
                if (ch2 == '\n') {
                    newString.append('\\');
                    newString.append('\n');
                    continue;
                }
                if (ch2 != '\r') continue;
                newString.append('\\');
                newString.append('\n');
                if (++i >= s.length() || s.charAt(i) != '\n') continue;
                newString.append('\r');
            }
            if (breakPoint == -1) {
                newString.append(s);
                return newString.toString();
            }
            newString.append(s.substring(0, breakPoint));
            newString.append("\r\n");
            newString.append(breakChar);
            s = s.substring(breakPoint + 1);
            used = 1;
        }
        newString.append(s);
        return newString.toString();
    }

    public static String unfold(String s) {
        if (!SessionUtil.getBooleanProperty(MIME_FOLDTEXT, true)) {
            return s;
        }
        if (s.indexOf(10) < 0 && s.indexOf(13) < 0) {
            return s;
        }
        int length = s.length();
        StringBuffer newString = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (i == length - 1) {
                    newString.append(ch);
                    continue;
                }
                char nextChar = s.charAt(i + 1);
                if (nextChar == '\n') {
                    newString.append('\n');
                    ++i;
                    continue;
                }
                if (nextChar == '\r') {
                    if (i == length - 2 || s.charAt(i + 2) != '\r') {
                        newString.append('\r');
                        ++i;
                        continue;
                    }
                    newString.append('\r');
                    newString.append('\n');
                    i += 2;
                    continue;
                }
                newString.append(ch);
                continue;
            }
            if (ch == '\n' || ch == '\r') {
                int scan;
                boolean CRLF = false;
                if (ch == '\r' && i < length - 1 && s.charAt(i + 1) == '\n') {
                    ++i;
                    CRLF = true;
                }
                if ((scan = i + 1) < length && s.charAt(scan) == ' ') {
                    newString.append(' ');
                    for (i = scan + 1; i < length && s.charAt(i) == ' '; ++i) {
                    }
                    --i;
                    continue;
                }
                if (CRLF) {
                    newString.append("\r\n");
                    continue;
                }
                newString.append(ch);
                continue;
            }
            newString.append(ch);
        }
        return newString.toString();
    }

    static int verifyAscii(String s) {
        int ascii_characters = 0;
        int non_ascii_characters = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (MimeUtility.nonascii(s.charAt(i))) {
                ++non_ascii_characters;
                continue;
            }
            ++ascii_characters;
        }
        if (non_ascii_characters == 0) {
            return 1;
        }
        if (ascii_characters > non_ascii_characters) {
            return 2;
        }
        return 3;
    }

    static final boolean nonascii(int a) {
        return a >= 127 || a < 32 && a != 13 && a != 10 && a != 9;
    }

    static {
        MimeUtility.loadCharacterSetMappings();
    }
}

