/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.KeyValueFileStore;
import org.apache.flink.table.store.file.mergetree.compact.DeduplicateMergeFunction;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunctionFactory;
import org.apache.flink.table.store.file.mergetree.compact.PartialUpdateMergeFunction;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.AggregateMergeFunction;
import org.apache.flink.table.store.file.operation.KeyValueFileStoreScan;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.KeyValueFieldsExtractor;
import org.apache.flink.table.store.file.schema.RowDataType;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.table.AbstractFileStoreTable;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.sink.SequenceGenerator;
import org.apache.flink.table.store.table.sink.SinkRecordConverter;
import org.apache.flink.table.store.table.sink.TableWrite;
import org.apache.flink.table.store.table.sink.TableWriteImpl;
import org.apache.flink.table.store.table.source.AbstractDataTableScan;
import org.apache.flink.table.store.table.source.KeyValueTableRead;
import org.apache.flink.table.store.table.source.MergeTreeSplitGenerator;
import org.apache.flink.table.store.table.source.SplitGenerator;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.table.source.ValueContentRowDataRecordIterator;
import org.apache.flink.table.types.logical.RowType;

public class ChangelogWithKeyFileStoreTable
extends AbstractFileStoreTable {
    private static final long serialVersionUID = 1L;
    private transient KeyValueFileStore lazyStore;

    ChangelogWithKeyFileStoreTable(Path path, TableSchema tableSchema) {
        super(path, tableSchema);
    }

    @Override
    protected FileStoreTable copy(TableSchema newTableSchema) {
        return new ChangelogWithKeyFileStoreTable(this.path, newTableSchema);
    }

    public KeyValueFileStore store() {
        if (this.lazyStore == null) {
            MergeFunctionFactory<KeyValue> mfFactory;
            RowType rowType = this.tableSchema.logicalRowType();
            Configuration conf = Configuration.fromMap(this.tableSchema.options());
            CoreOptions.MergeEngine mergeEngine = conf.get(CoreOptions.MERGE_ENGINE);
            switch (mergeEngine) {
                case DEDUPLICATE: {
                    mfFactory = DeduplicateMergeFunction.factory();
                    break;
                }
                case PARTIAL_UPDATE: {
                    mfFactory = PartialUpdateMergeFunction.factory(conf.get(CoreOptions.PARTIAL_UPDATE_IGNORE_DELETE), rowType.getChildren());
                    break;
                }
                case AGGREGATE: {
                    mfFactory = AggregateMergeFunction.factory(conf, this.tableSchema.fieldNames(), rowType.getChildren(), this.tableSchema.primaryKeys());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported merge engine: " + mergeEngine);
                }
            }
            CoreOptions options = new CoreOptions(conf);
            ChangelogWithKeyKeyValueFieldsExtractor extractor = ChangelogWithKeyKeyValueFieldsExtractor.EXTRACTOR;
            this.lazyStore = new KeyValueFileStore(this.schemaManager(), this.tableSchema.id(), options, this.tableSchema.logicalPartitionType(), ChangelogWithKeyFileStoreTable.addKeyNamePrefix(this.tableSchema.logicalBucketKeyType()), RowDataType.toRowType(false, extractor.keyFields(this.tableSchema)), rowType, extractor, mfFactory);
        }
        return this.lazyStore;
    }

    private static RowType addKeyNamePrefix(RowType type) {
        return new RowType(type.getFields().stream().map(f -> new RowType.RowField("_KEY_" + f.getName(), f.getType(), f.getDescription().orElse(null))).collect(Collectors.toList()));
    }

    private static List<DataField> addKeyNamePrefix(List<DataField> keyFields) {
        return keyFields.stream().map(f -> new DataField(f.id(), "_KEY_" + f.name(), f.type(), f.description())).collect(Collectors.toList());
    }

    @Override
    public AbstractDataTableScan newScan() {
        final KeyValueFileStoreScan scan = this.store().newScan();
        return new AbstractDataTableScan(scan, this.tableSchema, this.store().pathFactory(), this.options()){

            @Override
            protected SplitGenerator splitGenerator(FileStorePathFactory pathFactory) {
                return new MergeTreeSplitGenerator(ChangelogWithKeyFileStoreTable.this.store().newKeyComparator(), ChangelogWithKeyFileStoreTable.this.store().options().splitTargetSize(), ChangelogWithKeyFileStoreTable.this.store().options().splitOpenFileCost());
            }

            @Override
            protected void withNonPartitionFilter(Predicate predicate) {
                List<Predicate> keyFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), ChangelogWithKeyFileStoreTable.this.tableSchema.fieldNames(), ChangelogWithKeyFileStoreTable.this.tableSchema.trimmedPrimaryKeys());
                if (keyFilters.size() > 0) {
                    scan.withKeyFilter(PredicateBuilder.and(keyFilters));
                }
            }
        };
    }

    @Override
    public TableRead newRead() {
        return new KeyValueTableRead(this.store().newRead()){

            @Override
            public TableRead withFilter(Predicate predicate) {
                this.read.withFilter(predicate);
                return this;
            }

            @Override
            public TableRead withProjection(int[][] projection) {
                this.read.withValueProjection(projection);
                return this;
            }

            @Override
            protected RecordReader.RecordIterator<RowData> rowDataRecordIteratorFromKv(RecordReader.RecordIterator<KeyValue> kvRecordIterator) {
                return new ValueContentRowDataRecordIterator(kvRecordIterator);
            }
        };
    }

    @Override
    public TableWrite newWrite(String commitUser) {
        SequenceGenerator sequenceGenerator = this.store().options().sequenceField().map(field -> new SequenceGenerator((String)field, this.schema().logicalRowType())).orElse(null);
        KeyValue kv = new KeyValue();
        return new TableWriteImpl<KeyValue>(this.store().newWrite(commitUser), new SinkRecordConverter(this.tableSchema), record -> {
            long sequenceNumber = sequenceGenerator == null ? -1L : sequenceGenerator.generate(record.row());
            return kv.replace(record.primaryKey(), sequenceNumber, record.row().getRowKind(), record.row());
        });
    }

    static class ChangelogWithKeyKeyValueFieldsExtractor
    implements KeyValueFieldsExtractor {
        private static final long serialVersionUID = 1L;
        static final ChangelogWithKeyKeyValueFieldsExtractor EXTRACTOR = new ChangelogWithKeyKeyValueFieldsExtractor();

        private ChangelogWithKeyKeyValueFieldsExtractor() {
        }

        @Override
        public List<DataField> keyFields(TableSchema schema) {
            return ChangelogWithKeyFileStoreTable.addKeyNamePrefix(schema.trimmedPrimaryKeysFields());
        }

        @Override
        public List<DataField> valueFields(TableSchema schema) {
            return schema.fields();
        }
    }
}

