/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;

public class CatalogColumnStatisticsDataString
extends CatalogColumnStatisticsDataBase {
    private final Long maxLength;
    private final Double avgLength;
    private final Long ndv;

    public CatalogColumnStatisticsDataString(Long maxLength, Double avgLength, Long ndv, Long nullCount) {
        super(nullCount);
        this.maxLength = maxLength;
        this.avgLength = avgLength;
        this.ndv = ndv;
    }

    public CatalogColumnStatisticsDataString(Long maxLength, Double avgLength, Long ndv, Long nullCount, Map<String, String> properties) {
        super(nullCount, properties);
        this.maxLength = maxLength;
        this.avgLength = avgLength;
        this.ndv = ndv;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Double getAvgLength() {
        return this.avgLength;
    }

    public Long getNdv() {
        return this.ndv;
    }

    @Override
    public CatalogColumnStatisticsDataString copy() {
        return new CatalogColumnStatisticsDataString(this.maxLength, this.avgLength, this.ndv, this.getNullCount(), new HashMap<String, String>(this.getProperties()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogColumnStatisticsDataString that = (CatalogColumnStatisticsDataString)o;
        return Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.avgLength, that.avgLength) && Objects.equals(this.ndv, that.ndv) && Objects.equals(this.getNullCount(), that.getNullCount());
    }

    public int hashCode() {
        return Objects.hash(this.maxLength, this.avgLength, this.ndv, this.getNullCount());
    }

    public String toString() {
        return "CatalogColumnStatisticsDataString{maxLength=" + this.maxLength + ", avgLength=" + this.avgLength + ", ndv=" + this.ndv + ", nullCount=" + this.getNullCount() + '}';
    }
}

