/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.util.Preconditions;

public final class JobManagerRunnerResult {
    private final ExecutionGraphInfo executionGraphInfo;
    @Nullable
    private final Throwable failure;

    private JobManagerRunnerResult(ExecutionGraphInfo executionGraphInfo, @Nullable Throwable failure) {
        this.executionGraphInfo = executionGraphInfo;
        this.failure = failure;
    }

    public boolean isSuccess() {
        return this.failure == null;
    }

    public boolean isInitializationFailure() {
        return this.failure != null;
    }

    public ExecutionGraphInfo getExecutionGraphInfo() {
        return this.executionGraphInfo;
    }

    public Throwable getInitializationFailure() {
        Preconditions.checkState(this.isInitializationFailure());
        return this.failure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobManagerRunnerResult that = (JobManagerRunnerResult)o;
        return Objects.equals(this.executionGraphInfo, that.executionGraphInfo) && Objects.equals(this.failure, that.failure);
    }

    public int hashCode() {
        return Objects.hash(this.executionGraphInfo, this.failure);
    }

    public static JobManagerRunnerResult forSuccess(ExecutionGraphInfo executionGraphInfo) {
        return new JobManagerRunnerResult(executionGraphInfo, null);
    }

    public static JobManagerRunnerResult forInitializationFailure(ExecutionGraphInfo executionGraphInfo, Throwable failure) {
        return new JobManagerRunnerResult(executionGraphInfo, failure);
    }
}

