/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive.objectinspector;

import java.math.BigDecimal;
import org.apache.flink.table.data.DecimalData;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class TableStoreDecimalObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements HiveDecimalObjectInspector {
    public TableStoreDecimalObjectInspector(int precision, int scale) {
        super((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)precision, (int)scale));
    }

    public HiveDecimal getPrimitiveJavaObject(Object o) {
        return o == null ? null : HiveDecimal.create((BigDecimal)((DecimalData)o).toBigDecimal());
    }

    public HiveDecimalWritable getPrimitiveWritableObject(Object o) {
        HiveDecimal decimal = this.getPrimitiveJavaObject(o);
        return decimal == null ? null : new HiveDecimalWritable(decimal);
    }

    public Object copyObject(Object o) {
        if (o instanceof DecimalData) {
            return ((DecimalData)o).copy();
        }
        if (o instanceof HiveDecimal) {
            HiveDecimal hiveDecimal = (HiveDecimal)o;
            return HiveDecimal.create((BigDecimal)hiveDecimal.bigDecimalValue());
        }
        return o;
    }
}

