/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Phaser;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class InFlightRequestTracker {
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private final Phaser phaser = new Phaser(1){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            InFlightRequestTracker.this.terminationFuture.complete(null);
            return true;
        }
    };

    InFlightRequestTracker() {
    }

    public boolean registerRequest() {
        return this.phaser.register() >= 0;
    }

    public void deregisterRequest() {
        this.phaser.arriveAndDeregister();
    }

    public CompletableFuture<Void> awaitAsync() {
        this.phaser.arriveAndDeregister();
        return this.terminationFuture;
    }
}

