/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.system;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterators;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.IteratorRecordReader;
import org.apache.flink.table.store.file.utils.JsonSerdeUtil;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.table.source.TableScan;
import org.apache.flink.table.store.utils.ProjectedRowData;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.RowType;

public class SchemasTable
implements Table {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMAS = "schemas";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new RowType.RowField("schema_id", new BigIntType(false)), new RowType.RowField("fields", SerializationUtils.newStringType(false)), new RowType.RowField("partition_keys", SerializationUtils.newStringType(false)), new RowType.RowField("primary_keys", SerializationUtils.newStringType(false)), new RowType.RowField("options", SerializationUtils.newStringType(false)), new RowType.RowField("comment", SerializationUtils.newStringType(true))));
    private final Path location;

    public SchemasTable(Path location) {
        this.location = location;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + SCHEMAS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public Path location() {
        return this.location;
    }

    @Override
    public TableScan newScan() {
        return new SchemasScan();
    }

    @Override
    public TableRead newRead() {
        return new SchemasRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new SchemasTable(this.location);
    }

    private static class SchemasRead
    implements TableRead {
        private int[][] projection;

        private SchemasRead() {
        }

        @Override
        public TableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public RecordReader<RowData> createReader(Split split) throws IOException {
            if (!(split instanceof SchemasSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((SchemasSplit)split).location;
            Iterator<TableSchema> schemas = new SchemaManager(location).listAll().iterator();
            Iterator rows = Iterators.transform(schemas, this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform(rows, row -> ProjectedRowData.from(this.projection).replaceRow((RowData)row));
            }
            return new IteratorRecordReader<RowData>(rows);
        }

        private RowData toRow(TableSchema schema) {
            return GenericRowData.of(schema.id(), this.toJson(schema.fields()), this.toJson(schema.partitionKeys()), this.toJson(schema.primaryKeys()), this.toJson(schema.options()), StringData.fromString(schema.comment()));
        }

        private StringData toJson(Object obj) {
            return StringData.fromString(JsonSerdeUtil.toFlatJson(obj));
        }
    }

    private static class SchemasSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private SchemasSplit(Path location) {
            this.location = location;
        }

        @Override
        public long rowCount() {
            return new SchemaManager(this.location).listAllIds().size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemasSplit that = (SchemasSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class SchemasScan
    implements TableScan {
        private SchemasScan() {
        }

        @Override
        public TableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan plan() {
            return () -> Collections.singletonList(new SchemasSplit(SchemasTable.this.location));
        }
    }
}

