/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.avro;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.avro.shaded.org.apache.avro.AvroTypeException;
import org.apache.flink.avro.shaded.org.apache.avro.Conversion;
import org.apache.flink.avro.shaded.org.apache.avro.LogicalType;
import org.apache.flink.avro.shaded.org.apache.avro.LogicalTypes;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.SchemaCompatibility;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.reflect.AvroIgnore;
import org.apache.flink.avro.shaded.org.apache.avro.reflect.AvroName;
import org.apache.flink.avro.shaded.org.apache.avro.reflect.ReflectData;
import org.apache.flink.avro.shaded.org.apache.avro.reflect.Stringable;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificData;
import org.apache.flink.avro.shaded.org.apache.avro.util.ClassUtils;
import org.apache.flink.table.store.shaded.org.apache.parquet.Preconditions;
import org.apache.flink.table.store.shaded.org.apache.parquet.avro.AvroConverters;
import org.apache.flink.table.store.shaded.org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.flink.table.store.shaded.org.apache.parquet.avro.ParentValueContainer;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.InvalidRecordException;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.api.Converter;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.api.GroupConverter;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.GroupType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.MessageType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.Type;
import shaded.parquet.it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.ByteArrayList;
import shaded.parquet.it.unimi.dsi.fastutil.chars.CharArrayList;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import shaded.parquet.it.unimi.dsi.fastutil.floats.FloatArrayList;
import shaded.parquet.it.unimi.dsi.fastutil.ints.IntArrayList;
import shaded.parquet.it.unimi.dsi.fastutil.longs.LongArrayList;
import shaded.parquet.it.unimi.dsi.fastutil.shorts.ShortArrayList;

class AvroRecordConverter<T>
extends AvroConverters.AvroGroupConverter {
    private static final String STRINGABLE_PROP = "avro.java.string";
    private static final String JAVA_CLASS_PROP = "java-class";
    private static final String JAVA_KEY_CLASS_PROP = "java-key-class";
    protected T currentRecord = null;
    private ParentValueContainer rootContainer = null;
    private final Converter[] converters;
    private final Schema avroSchema;
    private final GenericData model;
    private final Map<Schema.Field, Object> recordDefaults = new HashMap<Schema.Field, Object>();
    private static final AvroSchemaConverter CONVERTER = new AvroSchemaConverter(true);

    public AvroRecordConverter(MessageType parquetSchema, Schema avroSchema, GenericData baseModel) {
        this(null, parquetSchema, avroSchema, baseModel);
        LogicalType logicalType = avroSchema.getLogicalType();
        Conversion<Object> conversion = baseModel.getConversionFor(logicalType);
        this.rootContainer = ParentValueContainer.getConversionContainer(new ParentValueContainer(){

            @Override
            public void add(Object value) {
                AvroRecordConverter.this.currentRecord = value;
            }
        }, conversion, avroSchema);
    }

    public AvroRecordConverter(ParentValueContainer parent, GroupType parquetSchema, Schema avroSchema, GenericData model) {
        super(parent);
        this.avroSchema = avroSchema;
        this.model = model == null ? ReflectData.get() : model;
        this.converters = new Converter[parquetSchema.getFieldCount()];
        HashMap<String, Integer> avroFieldIndexes = new HashMap<String, Integer>();
        int avroFieldIndex = 0;
        for (Schema.Field field : avroSchema.getFields()) {
            avroFieldIndexes.put(field.name(), avroFieldIndex++);
        }
        Class<T> recordClass = null;
        if (model instanceof ReflectData) {
            recordClass = AvroRecordConverter.getDatumClass(avroSchema, model);
        }
        Map<String, Class<?>> fields = AvroRecordConverter.getFieldsByName(recordClass, false);
        int parquetFieldIndex = 0;
        for (Type parquetField : parquetSchema.getFields()) {
            final Schema.Field avroField = this.getAvroField(parquetField.getName());
            Schema nonNullSchema = AvroSchemaConverter.getNonNull(avroField.schema());
            final int finalAvroIndex = (Integer)avroFieldIndexes.remove(avroField.name());
            ParentValueContainer container = new ParentValueContainer(){

                @Override
                public void add(Object value) {
                    AvroRecordConverter.this.set(avroField.name(), finalAvroIndex, value);
                }
            };
            Class<?> fieldClass = fields.get(avroField.name());
            this.converters[parquetFieldIndex] = AvroRecordConverter.newConverter(nonNullSchema, parquetField, this.model, fieldClass, container);
            if (recordClass != null && this.converters[parquetFieldIndex] instanceof AvroConverters.FieldStringConverter) {
                try {
                    Field field = recordClass.getDeclaredField(avroField.name());
                    if (field.isAnnotationPresent(Stringable.class)) {
                        this.converters[parquetFieldIndex] = new AvroConverters.FieldStringableConverter(container, field.getType());
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            ++parquetFieldIndex;
        }
        for (String fieldName : avroFieldIndexes.keySet()) {
            Schema.Field field = avroSchema.getField(fieldName);
            if (field.schema().getType() == Schema.Type.NULL || field.defaultVal() == null || this.model.getDefaultValue(field) == null) continue;
            this.recordDefaults.put(field, this.model.getDefaultValue(field));
        }
    }

    private static Map<String, Class<?>> getFieldsByName(Class<?> recordClass, boolean excludeJava) {
        LinkedHashMap fields = new LinkedHashMap();
        if (recordClass != null) {
            Class<?> current = recordClass;
            while (!excludeJava || current.getPackage() == null || !current.getPackage().getName().startsWith("java.")) {
                for (Field field : current.getDeclaredFields()) {
                    AvroName altName;
                    Class<?> existing;
                    if (field.isAnnotationPresent(AvroIgnore.class) || AvroRecordConverter.isTransientOrStatic(field) || (existing = fields.put((altName = field.getAnnotation(AvroName.class)) != null ? altName.value() : field.getName(), field.getType())) == null) continue;
                    throw new AvroTypeException(current + " contains two fields named: " + field.getName());
                }
                if ((current = current.getSuperclass()) != null) continue;
            }
        }
        return fields;
    }

    private static boolean isTransientOrStatic(Field field) {
        return (field.getModifiers() & 0x88) != 0;
    }

    private Schema.Field getAvroField(String parquetFieldName) {
        Schema.Field avroField = this.avroSchema.getField(parquetFieldName);
        if (avroField != null) {
            return avroField;
        }
        for (Schema.Field f : this.avroSchema.getFields()) {
            if (!f.aliases().contains(parquetFieldName)) continue;
            return f;
        }
        throw new InvalidRecordException(String.format("Parquet/Avro schema mismatch: Avro field '%s' not found", parquetFieldName));
    }

    private static Converter newConverter(Schema schema, Type type, GenericData model, ParentValueContainer setter) {
        return AvroRecordConverter.newConverter(schema, type, model, null, setter);
    }

    private static Converter newConverter(Schema schema, Type type, GenericData model, Class<?> knownClass, ParentValueContainer setter) {
        LogicalType logicalType = schema.getLogicalType();
        Conversion<Object> conversion = knownClass != null ? model.getConversionByClass(knownClass, logicalType) : model.getConversionFor(logicalType);
        ParentValueContainer parent = ParentValueContainer.getConversionContainer(setter, conversion, schema);
        switch (schema.getType()) {
            case BOOLEAN: {
                return new AvroConverters.FieldBooleanConverter(parent);
            }
            case INT: {
                Class<?> intDatumClass = AvroRecordConverter.getDatumClass(conversion, knownClass, schema, model);
                if (intDatumClass == null) {
                    return new AvroConverters.FieldIntegerConverter(parent);
                }
                if (intDatumClass == Byte.TYPE || intDatumClass == Byte.class) {
                    return new AvroConverters.FieldByteConverter(parent);
                }
                if (intDatumClass == Character.TYPE || intDatumClass == Character.class) {
                    return new AvroConverters.FieldCharConverter(parent);
                }
                if (intDatumClass == Short.TYPE || intDatumClass == Short.class) {
                    return new AvroConverters.FieldShortConverter(parent);
                }
                return new AvroConverters.FieldIntegerConverter(parent);
            }
            case LONG: {
                return new AvroConverters.FieldLongConverter(parent);
            }
            case FLOAT: {
                return new AvroConverters.FieldFloatConverter(parent);
            }
            case DOUBLE: {
                return new AvroConverters.FieldDoubleConverter(parent);
            }
            case BYTES: {
                Class<?> byteDatumClass = AvroRecordConverter.getDatumClass(conversion, knownClass, schema, model);
                if (byteDatumClass == null) {
                    return new AvroConverters.FieldByteBufferConverter(parent);
                }
                if (byteDatumClass.isArray() && byteDatumClass.getComponentType() == Byte.TYPE) {
                    return new AvroConverters.FieldByteArrayConverter(parent);
                }
                return new AvroConverters.FieldByteBufferConverter(parent);
            }
            case STRING: {
                if (logicalType != null && logicalType.getName().equals(LogicalTypes.uuid().getName())) {
                    return new AvroConverters.FieldUUIDConverter(parent, type.asPrimitiveType());
                }
                return AvroRecordConverter.newStringConverter(schema, model, parent);
            }
            case RECORD: {
                return new AvroRecordConverter(parent, type.asGroupType(), schema, model);
            }
            case ENUM: {
                return new AvroConverters.FieldEnumConverter(parent, schema, model);
            }
            case ARRAY: {
                Class<?> arrayDatumClass = AvroRecordConverter.getDatumClass(conversion, knownClass, schema, model);
                if (arrayDatumClass != null && arrayDatumClass.isArray()) {
                    return new AvroArrayConverter(parent, type.asGroupType(), schema, model, arrayDatumClass);
                }
                return new AvroCollectionConverter(parent, type.asGroupType(), schema, model, arrayDatumClass);
            }
            case MAP: {
                return new MapConverter(parent, type.asGroupType(), schema, model);
            }
            case UNION: {
                return new AvroUnionConverter(parent, type, schema, model);
            }
            case FIXED: {
                return new AvroConverters.FieldFixedConverter(parent, schema, model);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert Avro type: %s to Parquet type: %s", schema, type));
    }

    private static Converter newStringConverter(Schema schema, GenericData model, ParentValueContainer parent) {
        Class<?> stringableClass = AvroRecordConverter.getStringableClass(schema, model);
        if (stringableClass == String.class) {
            return new AvroConverters.FieldStringConverter(parent);
        }
        if (stringableClass == CharSequence.class) {
            return new AvroConverters.FieldUTF8Converter(parent);
        }
        return new AvroConverters.FieldStringableConverter(parent, stringableClass);
    }

    private static Class<?> getStringableClass(Schema schema, GenericData model) {
        boolean isMap;
        String stringableClass;
        if (model instanceof SpecificData && (stringableClass = schema.getProp((isMap = schema.getType() == Schema.Type.MAP) ? JAVA_KEY_CLASS_PROP : JAVA_CLASS_PROP)) != null) {
            try {
                return ClassUtils.forName(model.getClassLoader(), stringableClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (ReflectData.class.isAssignableFrom(model.getClass())) {
            return String.class;
        }
        String name = schema.getProp(STRINGABLE_PROP);
        if (name == null) {
            return CharSequence.class;
        }
        switch (GenericData.StringType.valueOf(name)) {
            case String: {
                return String.class;
            }
        }
        return CharSequence.class;
    }

    private static <T> Class<T> getDatumClass(Schema schema, GenericData model) {
        return AvroRecordConverter.getDatumClass(null, null, schema, model);
    }

    private static <T> Class<T> getDatumClass(Conversion<?> conversion, Class<T> knownClass, Schema schema, GenericData model) {
        Method getClassMethod;
        if (conversion != null) {
            return null;
        }
        if (knownClass != null) {
            return knownClass;
        }
        if (model instanceof SpecificData) {
            return ((SpecificData)model).getClass(schema);
        }
        if (model.getClass() == GenericData.class) {
            return null;
        }
        Class<?> modelClass = model.getClass();
        try {
            getClassMethod = modelClass.getMethod("getClass", Schema.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return (Class)getClassMethod.invoke((Object)schema, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    protected void set(String name, int avroIndex, Object value) {
        this.model.setField(this.currentRecord, name, avroIndex, value);
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    @Override
    public void start() {
        this.currentRecord = this.model.newRecord(null, this.avroSchema);
    }

    @Override
    public void end() {
        this.fillInDefaults();
        if (this.parent != null) {
            this.parent.add(this.currentRecord);
        } else {
            this.rootContainer.add(this.currentRecord);
        }
    }

    private void fillInDefaults() {
        for (Map.Entry<Schema.Field, Object> entry : this.recordDefaults.entrySet()) {
            Schema.Field f = entry.getKey();
            Object defaultValue = this.deepCopy(f.schema(), entry.getValue());
            this.set(f.name(), f.pos(), defaultValue);
        }
    }

    private Object deepCopy(Schema schema, Object value) {
        switch (schema.getType()) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return value;
            }
        }
        return this.model.deepCopy(schema, value);
    }

    T getCurrentRecord() {
        return this.currentRecord;
    }

    static boolean isElementType(Type repeatedType, Schema elementSchema) {
        Schema schemaFromRepeated;
        if (repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.asGroupType().getType(0).isRepetition(Type.Repetition.REPEATED)) {
            return true;
        }
        return elementSchema != null && elementSchema.getType() == Schema.Type.RECORD && SchemaCompatibility.checkReaderWriterCompatibility(elementSchema, schemaFromRepeated = CONVERTER.convert(repeatedType.asGroupType())).getType() == SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
    }

    static final class MapConverter<K, V>
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Converter keyValueConverter;
        private final Schema schema;
        private final Class<?> mapClass;
        private Map<K, V> map;

        public MapConverter(ParentValueContainer parent, GroupType mapType, Schema mapSchema, GenericData model) {
            this.parent = parent;
            GroupType repeatedKeyValueType = mapType.getType(0).asGroupType();
            this.keyValueConverter = new MapKeyValueConverter(repeatedKeyValueType, mapSchema, model);
            this.schema = mapSchema;
            this.mapClass = AvroRecordConverter.getDatumClass(mapSchema, model);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.keyValueConverter;
        }

        @Override
        public void start() {
            this.map = this.newMap();
        }

        @Override
        public void end() {
            this.parent.add(this.map);
        }

        private Map<K, V> newMap() {
            if (this.mapClass == null || this.mapClass.isAssignableFrom(HashMap.class)) {
                return new HashMap();
            }
            return (Map)ReflectData.newInstance(this.mapClass, this.schema);
        }

        final class MapKeyValueConverter
        extends GroupConverter {
            private K key;
            private V value;
            private final Converter keyConverter;
            private final Converter valueConverter;

            public MapKeyValueConverter(GroupType keyValueType, Schema mapSchema, GenericData model) {
                this.keyConverter = AvroRecordConverter.newStringConverter(mapSchema, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        MapKeyValueConverter.this.key = value;
                    }
                });
                Type valueType = keyValueType.getType(1);
                Schema nonNullValueSchema = AvroSchemaConverter.getNonNull(mapSchema.getValueType());
                this.valueConverter = AvroRecordConverter.newConverter(nonNullValueSchema, valueType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        MapKeyValueConverter.this.value = value;
                    }
                });
            }

            @Override
            public Converter getConverter(int fieldIndex) {
                if (fieldIndex == 0) {
                    return this.keyConverter;
                }
                if (fieldIndex == 1) {
                    return this.valueConverter;
                }
                throw new IllegalArgumentException("only the key (0) and value (1) fields expected: " + fieldIndex);
            }

            @Override
            public void start() {
                this.key = null;
                this.value = null;
            }

            @Override
            public void end() {
                MapConverter.this.map.put(this.key, this.value);
            }
        }
    }

    static final class AvroUnionConverter
    extends AvroConverters.AvroGroupConverter {
        private final Converter[] memberConverters;
        private Object memberValue = null;

        public AvroUnionConverter(ParentValueContainer parent, Type parquetSchema, Schema avroSchema, GenericData model) {
            super(parent);
            GroupType parquetGroup = parquetSchema.asGroupType();
            this.memberConverters = new Converter[parquetGroup.getFieldCount()];
            int parquetIndex = 0;
            for (int index = 0; index < avroSchema.getTypes().size(); ++index) {
                Schema memberSchema = avroSchema.getTypes().get(index);
                if (memberSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                Type memberType = parquetGroup.getType(parquetIndex);
                this.memberConverters[parquetIndex] = AvroRecordConverter.newConverter(memberSchema, memberType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        Preconditions.checkArgument(memberValue == null, "Union is resolving to more than one type");
                        memberValue = value;
                    }
                });
                ++parquetIndex;
            }
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.memberConverters[fieldIndex];
        }

        @Override
        public void start() {
            this.memberValue = null;
        }

        @Override
        public void end() {
            this.parent.add(this.memberValue);
        }
    }

    static final class AvroArrayConverter
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Schema avroSchema;
        private final Converter converter;
        private Class<?> elementClass;
        private Collection<?> container;

        public AvroArrayConverter(ParentValueContainer parent, GroupType type, Schema avroSchema, GenericData model, Class<?> arrayClass) {
            this.parent = parent;
            this.avroSchema = avroSchema;
            Preconditions.checkArgument(arrayClass.isArray(), "Cannot convert non-array: " + arrayClass.getName());
            this.elementClass = arrayClass.getComponentType();
            ParentValueContainer setter = this.createSetterAndContainer();
            Schema elementSchema = this.avroSchema.getElementType();
            Type repeatedType = type.getType(0);
            this.converter = AvroRecordConverter.isElementType(repeatedType, elementSchema) ? AvroRecordConverter.newConverter(elementSchema, repeatedType, model, this.elementClass, setter) : new ArrayElementConverter(repeatedType.asGroupType(), elementSchema, model, setter);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        @Override
        public void start() {
            this.container.clear();
        }

        @Override
        public void end() {
            if (this.elementClass == Boolean.TYPE) {
                this.parent.add(((BooleanArrayList)this.container).toBooleanArray());
            } else if (this.elementClass == Byte.TYPE) {
                this.parent.add(((ByteArrayList)this.container).toByteArray());
            } else if (this.elementClass == Character.TYPE) {
                this.parent.add(((CharArrayList)this.container).toCharArray());
            } else if (this.elementClass == Short.TYPE) {
                this.parent.add(((ShortArrayList)this.container).toShortArray());
            } else if (this.elementClass == Integer.TYPE) {
                this.parent.add(((IntArrayList)this.container).toIntArray());
            } else if (this.elementClass == Long.TYPE) {
                this.parent.add(((LongArrayList)this.container).toLongArray());
            } else if (this.elementClass == Float.TYPE) {
                this.parent.add(((FloatArrayList)this.container).toFloatArray());
            } else if (this.elementClass == Double.TYPE) {
                this.parent.add(((DoubleArrayList)this.container).toDoubleArray());
            } else {
                this.parent.add(((ArrayList)this.container).toArray());
            }
        }

        private ParentValueContainer createSetterAndContainer() {
            if (this.elementClass == Boolean.TYPE) {
                BooleanArrayList list;
                this.container = list = new BooleanArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addBoolean(boolean value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Byte.TYPE) {
                ByteArrayList list;
                this.container = list = new ByteArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addByte(byte value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Character.TYPE) {
                CharArrayList list;
                this.container = list = new CharArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addChar(char value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Short.TYPE) {
                ShortArrayList list;
                this.container = list = new ShortArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addShort(short value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Integer.TYPE) {
                IntArrayList list;
                this.container = list = new IntArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addInt(int value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Long.TYPE) {
                LongArrayList list;
                this.container = list = new LongArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addLong(long value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Float.TYPE) {
                FloatArrayList list;
                this.container = list = new FloatArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addFloat(float value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Double.TYPE) {
                DoubleArrayList list;
                this.container = list = new DoubleArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addDouble(double value) {
                        list.add(value);
                    }
                };
            }
            final ArrayList list = new ArrayList();
            this.container = list;
            return new ParentValueContainer(){

                @Override
                public void add(Object value) {
                    list.add(value);
                }
            };
        }

        final class ArrayElementConverter
        extends GroupConverter {
            private boolean isSet;
            private final Converter elementConverter;

            public ArrayElementConverter(GroupType repeatedType, Schema elementSchema, GenericData model, final ParentValueContainer setter) {
                Type elementType = repeatedType.getType(0);
                Preconditions.checkArgument(!AvroArrayConverter.this.elementClass.isPrimitive() || elementType.isRepetition(Type.Repetition.REQUIRED), "Cannot convert list of optional elements to primitive array");
                Schema nonNullElementSchema = AvroSchemaConverter.getNonNull(elementSchema);
                this.elementConverter = AvroRecordConverter.newConverter(nonNullElementSchema, elementType, model, AvroArrayConverter.this.elementClass, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.add(value);
                    }

                    @Override
                    public void addByte(byte value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.addByte(value);
                    }

                    @Override
                    public void addBoolean(boolean value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.addBoolean(value);
                    }

                    @Override
                    public void addChar(char value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.addChar(value);
                    }

                    @Override
                    public void addShort(short value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.addShort(value);
                    }

                    @Override
                    public void addInt(int value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.addInt(value);
                    }

                    @Override
                    public void addLong(long value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.addLong(value);
                    }

                    @Override
                    public void addFloat(float value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.addFloat(value);
                    }

                    @Override
                    public void addDouble(double value) {
                        ArrayElementConverter.this.isSet = true;
                        setter.addDouble(value);
                    }
                });
            }

            @Override
            public Converter getConverter(int fieldIndex) {
                Preconditions.checkArgument(fieldIndex == 0, "Illegal field index: " + fieldIndex);
                return this.elementConverter;
            }

            @Override
            public void start() {
                this.isSet = false;
            }

            @Override
            public void end() {
                if (!this.isSet) {
                    AvroArrayConverter.this.container.add(null);
                }
            }
        }
    }

    static final class AvroCollectionConverter
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Schema avroSchema;
        private final Converter converter;
        private Class<?> containerClass;
        private Collection<Object> container;

        public AvroCollectionConverter(ParentValueContainer parent, GroupType type, Schema avroSchema, GenericData model, Class<?> containerClass) {
            this.parent = parent;
            this.avroSchema = avroSchema;
            this.containerClass = containerClass;
            Schema elementSchema = AvroSchemaConverter.getNonNull(avroSchema.getElementType());
            Type repeatedType = type.getType(0);
            this.converter = AvroRecordConverter.isElementType(repeatedType, elementSchema) ? AvroRecordConverter.newConverter(elementSchema, repeatedType, model, new ParentValueContainer(){

                @Override
                public void add(Object value) {
                    container.add(value);
                }
            }) : new ElementConverter(repeatedType.asGroupType(), elementSchema, model);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        @Override
        public void start() {
            this.container = this.newContainer();
        }

        @Override
        public void end() {
            this.parent.add(this.container);
        }

        private Collection<Object> newContainer() {
            if (this.containerClass == null) {
                return new GenericData.Array<Object>(0, this.avroSchema);
            }
            if (this.containerClass.isAssignableFrom(ArrayList.class)) {
                return new ArrayList<Object>();
            }
            return (Collection)ReflectData.newInstance(this.containerClass, this.avroSchema);
        }

        final class ElementConverter
        extends GroupConverter {
            private Object element;
            private final Converter elementConverter;

            public ElementConverter(GroupType repeatedType, Schema elementSchema, GenericData model) {
                Type elementType = repeatedType.getType(0);
                Schema nonNullElementSchema = AvroSchemaConverter.getNonNull(elementSchema);
                this.elementConverter = AvroRecordConverter.newConverter(nonNullElementSchema, elementType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        ElementConverter.this.element = value;
                    }
                });
            }

            @Override
            public Converter getConverter(int fieldIndex) {
                Preconditions.checkArgument(fieldIndex == 0, "Illegal field index: " + fieldIndex);
                return this.elementConverter;
            }

            @Override
            public void start() {
                this.element = null;
            }

            @Override
            public void end() {
                AvroCollectionConverter.this.container.add(this.element);
            }
        }
    }
}

