/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.aggr.IExtrapolatePartStatus;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.aggr.LongColumnStatsAggregator;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringColumnStatsAggregator
extends ColumnStatsAggregator
implements IExtrapolatePartStatus {
    private static final Logger LOG = LoggerFactory.getLogger(LongColumnStatsAggregator.class);

    @Override
    public ColumnStatisticsObj aggregate(List<MetaStoreUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        ColumnStatisticsObj statsObj = null;
        String colType = null;
        String colName = null;
        boolean doAllPartitionContainStats = partNames.size() == colStatsWithSourceInfo.size();
        NumDistinctValueEstimator ndvEstimator = null;
        for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
            StringColumnStatsDataInspector stringColumnStatsData;
            ColumnStatisticsObj cso = csp.getColStatsObj();
            if (statsObj == null) {
                colName = cso.getColName();
                colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
                LOG.trace("doAllPartitionContainStats for column: {} is: {}", (Object)colName, (Object)doAllPartitionContainStats);
            }
            if ((stringColumnStatsData = (StringColumnStatsDataInspector)cso.getStatsData().getStringStats()).getNdvEstimator() == null) {
                ndvEstimator = null;
                break;
            }
            NumDistinctValueEstimator estimator = stringColumnStatsData.getNdvEstimator();
            if (ndvEstimator == null) {
                ndvEstimator = estimator;
                continue;
            }
            if (ndvEstimator.canMerge(estimator)) continue;
            ndvEstimator = null;
            break;
        }
        if (ndvEstimator != null) {
            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
        }
        LOG.debug("all of the bit vectors can merge for " + colName + " is " + (ndvEstimator != null));
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        if (doAllPartitionContainStats || colStatsWithSourceInfo.size() < 2) {
            StringColumnStatsData aggregateData = null;
            for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                ColumnStatisticsObj cso = csp.getColStatsObj();
                StringColumnStatsDataInspector newData = (StringColumnStatsDataInspector)cso.getStatsData().getStringStats();
                if (ndvEstimator != null) {
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (aggregateData == null) {
                    aggregateData = newData.deepCopy();
                    continue;
                }
                aggregateData.setMaxColLen(Math.max(aggregateData.getMaxColLen(), newData.getMaxColLen()));
                aggregateData.setAvgColLen(Math.max(aggregateData.getAvgColLen(), newData.getAvgColLen()));
                aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
            }
            if (ndvEstimator != null) {
                aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
            }
            columnStatisticsData.setStringStats(aggregateData);
        } else {
            LOG.debug("start extrapolation for " + colName);
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap<String, Double> adjustedIndexMap = new HashMap<String, Double>();
            HashMap<String, ColumnStatisticsData> adjustedStatsMap = new HashMap<String, ColumnStatisticsData>();
            if (ndvEstimator == null) {
                for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    adjustedIndexMap.put(partName, (double)((Integer)indexMap.get(partName)));
                    adjustedStatsMap.put(partName, cso.getStatsData());
                }
            } else {
                StringBuilder pseudoPartName = new StringBuilder();
                double pseudoIndexSum = 0.0;
                int length = 0;
                int curIndex = -1;
                StringColumnStatsData aggregateData = null;
                for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
                    ColumnStatisticsObj cso = csp.getColStatsObj();
                    String partName = csp.getPartName();
                    StringColumnStatsDataInspector newData = (StringColumnStatsDataInspector)cso.getStatsData().getStringStats();
                    if ((Integer)indexMap.get(partName) != curIndex) {
                        if (length > 0) {
                            adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                            aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                            ColumnStatisticsData csd = new ColumnStatisticsData();
                            csd.setStringStats(aggregateData);
                            adjustedStatsMap.put(pseudoPartName.toString(), csd);
                            pseudoPartName = new StringBuilder();
                            pseudoIndexSum = 0.0;
                            length = 0;
                            ndvEstimator = NumDistinctValueEstimatorFactory.getEmptyNumDistinctValueEstimator(ndvEstimator);
                        }
                        aggregateData = null;
                    }
                    curIndex = (Integer)indexMap.get(partName);
                    pseudoPartName.append(partName);
                    pseudoIndexSum += (double)curIndex;
                    ++length;
                    ++curIndex;
                    if (aggregateData == null) {
                        aggregateData = newData.deepCopy();
                    } else {
                        aggregateData.setAvgColLen(Math.max(aggregateData.getAvgColLen(), newData.getAvgColLen()));
                        aggregateData.setMaxColLen(Math.max(aggregateData.getMaxColLen(), newData.getMaxColLen()));
                        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
                    }
                    ndvEstimator.mergeEstimators(newData.getNdvEstimator());
                }
                if (length > 0) {
                    adjustedIndexMap.put(pseudoPartName.toString(), pseudoIndexSum / (double)length);
                    aggregateData.setNumDVs(ndvEstimator.estimateNumDistinctValues());
                    ColumnStatisticsData csd = new ColumnStatisticsData();
                    csd.setStringStats(aggregateData);
                    adjustedStatsMap.put(pseudoPartName.toString(), csd);
                }
            }
            this.extrapolate(columnStatisticsData, partNames.size(), colStatsWithSourceInfo.size(), adjustedIndexMap, adjustedStatsMap, -1.0);
        }
        LOG.debug("Ndv estimatation for {} is {} # of partitions requested: {} # of partitions found: {}", new Object[]{colName, columnStatisticsData.getStringStats().getNumDVs(), partNames.size(), colStatsWithSourceInfo.size()});
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }

    @Override
    public void extrapolate(ColumnStatisticsData extrapolateData, int numParts, int numPartsWithStats, Map<String, Double> adjustedIndexMap, Map<String, ColumnStatisticsData> adjustedStatsMap, double densityAvg) {
        int rightBorderInd = numParts;
        StringColumnStatsDataInspector extrapolateStringData = new StringColumnStatsDataInspector();
        HashMap<String, StringColumnStatsData> extractedAdjustedStatsMap = new HashMap<String, StringColumnStatsData>();
        for (Map.Entry<String, ColumnStatisticsData> entry : adjustedStatsMap.entrySet()) {
            extractedAdjustedStatsMap.put(entry.getKey(), entry.getValue().getStringStats());
        }
        LinkedList list = new LinkedList(extractedAdjustedStatsMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, StringColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, StringColumnStatsData> o1, Map.Entry<String, StringColumnStatsData> o2) {
                return Double.compare(o1.getValue().getAvgColLen(), o2.getValue().getAvgColLen());
            }
        });
        double minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        double maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        double avgColLen = 0.0;
        double min = ((StringColumnStatsData)((Map.Entry)list.get(0)).getValue()).getAvgColLen();
        double max = ((StringColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getAvgColLen();
        avgColLen = minInd == maxInd ? min : (minInd < maxInd ? min + (max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd) : min + (max - min) * minInd / (minInd - maxInd));
        Collections.sort(list, new Comparator<Map.Entry<String, StringColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, StringColumnStatsData> o1, Map.Entry<String, StringColumnStatsData> o2) {
                return Long.compare(o1.getValue().getMaxColLen(), o2.getValue().getMaxColLen());
            }
        });
        minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        double maxColLen = 0.0;
        min = ((StringColumnStatsData)((Map.Entry)list.get(0)).getValue()).getAvgColLen();
        max = ((StringColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getAvgColLen();
        maxColLen = minInd == maxInd ? min : (minInd < maxInd ? min + (max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd) : min + (max - min) * minInd / (minInd - maxInd));
        long numNulls = 0L;
        for (Map.Entry entry : extractedAdjustedStatsMap.entrySet()) {
            numNulls += ((StringColumnStatsData)entry.getValue()).getNumNulls();
        }
        numNulls = numNulls * (long)numParts / (long)numPartsWithStats;
        long ndv = 0L;
        Collections.sort(list, new Comparator<Map.Entry<String, StringColumnStatsData>>(){

            @Override
            public int compare(Map.Entry<String, StringColumnStatsData> o1, Map.Entry<String, StringColumnStatsData> o2) {
                return Long.compare(o1.getValue().getNumDVs(), o2.getValue().getNumDVs());
            }
        });
        minInd = adjustedIndexMap.get(((Map.Entry)list.get(0)).getKey());
        maxInd = adjustedIndexMap.get(((Map.Entry)list.get(list.size() - 1)).getKey());
        min = ((StringColumnStatsData)((Map.Entry)list.get(0)).getValue()).getNumDVs();
        max = ((StringColumnStatsData)((Map.Entry)list.get(list.size() - 1)).getValue()).getNumDVs();
        ndv = minInd == maxInd ? (long)min : (minInd < maxInd ? (long)(min + (max - min) * ((double)rightBorderInd - minInd) / (maxInd - minInd)) : (long)(min + (max - min) * minInd / (minInd - maxInd)));
        extrapolateStringData.setAvgColLen(avgColLen);
        extrapolateStringData.setMaxColLen((long)maxColLen);
        extrapolateStringData.setNumNulls(numNulls);
        extrapolateStringData.setNumDVs(ndv);
        extrapolateData.setStringStats(extrapolateStringData);
    }
}

