/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll;

import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.ndv.hll.HLLRegister;

public class HLLSparseRegister
implements HLLRegister {
    private TreeMap<Integer, Byte> sparseMap;
    private int[] tempList;
    private int tempListIdx;
    private final int p;
    private final int pPrime;
    private final int qPrime;
    private final int mask;
    private final int pPrimeMask;
    private final int qPrimeMask;

    public HLLSparseRegister(int p, int pp, int qp) {
        this.p = p;
        this.sparseMap = new TreeMap();
        this.tempList = new int[1024];
        this.tempListIdx = 0;
        this.pPrime = pp;
        this.qPrime = qp;
        this.mask = (1 << this.pPrime) - 1 ^ (1 << p) - 1;
        this.pPrimeMask = (1 << this.pPrime) - 1;
        this.qPrimeMask = (1 << this.qPrime) - 1;
    }

    @Override
    public boolean add(long hashcode) {
        boolean updated = false;
        if (this.tempListIdx < this.tempList.length) {
            int encodedHash = this.encodeHash(hashcode);
            this.tempList[this.tempListIdx++] = encodedHash;
            updated = true;
        } else {
            updated = this.mergeTempListToSparseMap();
        }
        return updated;
    }

    private boolean mergeTempListToSparseMap() {
        boolean updated = false;
        for (int i = 0; i < this.tempListIdx; ++i) {
            int encodedHash = this.tempList[i];
            int key = encodedHash & this.pPrimeMask;
            byte value = (byte)(encodedHash >>> this.pPrime);
            byte nr = 0;
            nr = encodedHash < 0 ? (byte)(value & this.qPrimeMask) : (byte)(Integer.numberOfTrailingZeros(encodedHash >>> this.p) + 1);
            updated = this.set(key, nr);
        }
        this.tempListIdx = 0;
        return updated;
    }

    public int encodeHash(long hashcode) {
        int x = (int)(hashcode & (long)this.mask);
        if (x == 0) {
            int ntr = Long.numberOfTrailingZeros(hashcode >> this.p) + 1;
            long newHashCode = hashcode & (long)this.pPrimeMask;
            newHashCode |= (long)(ntr << this.pPrime);
            return (int)(newHashCode |= Integer.MIN_VALUE);
        }
        return (int)(hashcode & Integer.MAX_VALUE);
    }

    public int getSize() {
        return this.sparseMap.size() + this.tempListIdx;
    }

    @Override
    public void merge(HLLRegister hllRegister) {
        if (hllRegister instanceof HLLSparseRegister) {
            HLLSparseRegister hsr = (HLLSparseRegister)hllRegister;
            for (Map.Entry<Integer, Byte> entry : hsr.getSparseMap().entrySet()) {
                int key = entry.getKey();
                byte value = entry.getValue();
                this.set(key, value);
            }
        } else {
            throw new IllegalArgumentException("Specified register not instance of HLLSparseRegister");
        }
    }

    @Override
    public boolean set(int key, byte value) {
        Byte containedValue = this.sparseMap.get(key);
        if (containedValue == null || value > containedValue) {
            this.sparseMap.put(key, value);
            return true;
        }
        return false;
    }

    public TreeMap<Integer, Byte> getSparseMap() {
        return this.getMergedSparseMap();
    }

    private TreeMap<Integer, Byte> getMergedSparseMap() {
        if (this.tempListIdx != 0) {
            this.mergeTempListToSparseMap();
        }
        return this.sparseMap;
    }

    public void extractLowBitsTo(HLLRegister dest) {
        for (Map.Entry<Integer, Byte> entry : this.getSparseMap().entrySet()) {
            int idx = entry.getKey();
            byte lr = entry.getValue();
            if (lr == 0) continue;
            dest.add(1 << this.p + lr - 1 | idx);
        }
    }

    public int getP() {
        return this.p;
    }

    public int getPPrime() {
        return this.pPrime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HLLSparseRegister - ");
        sb.append("p: ");
        sb.append(this.p);
        sb.append(" pPrime: ");
        sb.append(this.pPrime);
        sb.append(" qPrime: ");
        sb.append(this.qPrime);
        return sb.toString();
    }

    public String toExtendedString() {
        return this.toString() + " register: " + this.sparseMap.toString();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (!(obj instanceof HLLSparseRegister)) {
            return false;
        }
        HLLSparseRegister other = (HLLSparseRegister)obj;
        boolean bl = result = this.p == other.p && this.pPrime == other.pPrime && this.qPrime == other.qPrime && this.tempListIdx == other.tempListIdx;
        if (result) {
            for (int i = 0; i < this.tempListIdx; ++i) {
                if (this.tempList[i] == other.tempList[i]) continue;
                return false;
            }
            result = result && this.sparseMap.equals(other.sparseMap);
        }
        return result;
    }

    public int hashCode() {
        int hashcode = 0;
        hashcode += 31 * this.p;
        hashcode += 31 * this.pPrime;
        hashcode += 31 * this.qPrime;
        for (int i = 0; i < this.tempListIdx; ++i) {
            hashcode += 31 * this.tempList[this.tempListIdx];
        }
        return hashcode += this.sparseMap.hashCode();
    }
}

