/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.file.CodecFactory;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.file.DataFileWriter;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericDatumWriter;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.format.avro.AbstractAvroBulkFormat;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.AvroBuilder;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.AvroWriterFactory;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class AvroFileFormat
extends FileFormat {
    private final ReadableConfig formatOptions;

    public AvroFileFormat(ReadableConfig formatOptions) {
        super("avro");
        this.formatOptions = formatOptions;
    }

    @Override
    public BulkFormat<RowData, FileSourceSplit> createReaderFactory(RowType type, int[][] projection, @Nullable List<Predicate> filters) {
        LogicalType producedType = Projection.of(projection).project((LogicalType)type);
        return new AvroGenericRecordBulkFormat((RowType)producedType.copy(false), (TypeInformation<RowData>)InternalTypeInfo.of((LogicalType)producedType));
    }

    @Override
    public BulkWriter.Factory<RowData> createWriterFactory(RowType type) {
        return new RowDataAvroWriterFactory(type, (String)this.formatOptions.get(AvroFormatOptions.AVRO_OUTPUT_CODEC));
    }

    private static class RowDataAvroWriterFactory
    implements BulkWriter.Factory<RowData> {
        private static final long serialVersionUID = 1L;
        private final AvroWriterFactory<GenericRecord> factory;
        private final RowType rowType;

        private RowDataAvroWriterFactory(final RowType rowType, final String codec) {
            this.rowType = rowType;
            this.factory = new AvroWriterFactory<GenericRecord>(new AvroBuilder<GenericRecord>(){

                @Override
                public DataFileWriter<GenericRecord> createWriter(OutputStream out) throws IOException {
                    Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)rowType);
                    GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
                    DataFileWriter<GenericRecord> dataFileWriter = new DataFileWriter<GenericRecord>(datumWriter);
                    if (codec != null) {
                        dataFileWriter.setCodec(CodecFactory.fromString(codec));
                    }
                    dataFileWriter.create(schema, out);
                    return dataFileWriter;
                }
            });
        }

        public BulkWriter<RowData> create(FSDataOutputStream out) throws IOException {
            final BulkWriter<GenericRecord> writer = this.factory.create(out);
            final RowDataToAvroConverters.RowDataToAvroConverter converter = RowDataToAvroConverters.createConverter((LogicalType)this.rowType);
            final Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)this.rowType);
            return new BulkWriter<RowData>(){

                public void addElement(RowData element) throws IOException {
                    GenericRecord record = (GenericRecord)converter.convert(schema, element);
                    writer.addElement((Object)record);
                }

                public void flush() throws IOException {
                    writer.flush();
                }

                public void finish() throws IOException {
                    writer.finish();
                }
            };
        }
    }

    private static class AvroGenericRecordBulkFormat
    extends AbstractAvroBulkFormat<GenericRecord, RowData, FileSourceSplit> {
        private static final long serialVersionUID = 1L;
        private final RowType producedRowType;
        private final TypeInformation<RowData> producedTypeInfo;

        public AvroGenericRecordBulkFormat(RowType producedRowType, TypeInformation<RowData> producedTypeInfo) {
            super(AvroSchemaConverter.convertToSchema((LogicalType)producedRowType));
            this.producedRowType = producedRowType;
            this.producedTypeInfo = producedTypeInfo;
        }

        @Override
        protected GenericRecord createReusedAvroRecord() {
            return new GenericData.Record(this.readerSchema);
        }

        @Override
        protected Function<GenericRecord, RowData> createConverter() {
            AvroToRowDataConverters.AvroToRowDataConverter converter = AvroToRowDataConverters.createRowConverter(this.producedRowType);
            return record -> record == null ? null : (GenericRowData)converter.convert(record);
        }

        public TypeInformation<RowData> getProducedType() {
            return this.producedTypeInfo;
        }
    }
}

