/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public final class OutputArgumentTypeStrategy
implements ArgumentTypeStrategy {
    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        DataType actualDataType = callContext.getArgumentDataTypes().get(argumentPos);
        if (actualDataType.getLogicalType().is(LogicalTypeRoot.NULL)) {
            return callContext.getOutputDataType();
        }
        return Optional.of(actualDataType);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of("<OUTPUT>");
    }

    public boolean equals(Object o) {
        return this == o || o instanceof OutputArgumentTypeStrategy;
    }

    public int hashCode() {
        return OutputArgumentTypeStrategy.class.hashCode();
    }
}

