/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.TaskExecutorBlobService;
import org.apache.flink.runtime.blob.TransientBlobCache;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Reference;

public class BlobCacheService
implements TaskExecutorBlobService {
    private final PermanentBlobCache permanentBlobCache;
    private final TransientBlobCache transientBlobCache;

    public BlobCacheService(Configuration blobClientConfig, File storageDir, BlobView blobView, @Nullable InetSocketAddress serverAddress) throws IOException {
        this(blobClientConfig, Reference.owned(storageDir), blobView, serverAddress);
    }

    public BlobCacheService(Configuration blobClientConfig, Reference<File> storageDir, BlobView blobView, @Nullable InetSocketAddress serverAddress) throws IOException {
        this(new PermanentBlobCache(blobClientConfig, storageDir, blobView, serverAddress), new TransientBlobCache(blobClientConfig, storageDir, serverAddress));
    }

    public BlobCacheService(PermanentBlobCache permanentBlobCache, TransientBlobCache transientBlobCache) {
        this.permanentBlobCache = Preconditions.checkNotNull(permanentBlobCache);
        this.transientBlobCache = Preconditions.checkNotNull(transientBlobCache);
    }

    @Override
    public PermanentBlobCache getPermanentBlobService() {
        return this.permanentBlobCache;
    }

    @Override
    public TransientBlobCache getTransientBlobService() {
        return this.transientBlobCache;
    }

    @Override
    public void setBlobServerAddress(InetSocketAddress blobServerAddress) {
        this.permanentBlobCache.setBlobServerAddress(blobServerAddress);
        this.transientBlobCache.setBlobServerAddress(blobServerAddress);
    }

    @Override
    public void close() throws IOException {
        this.permanentBlobCache.close();
        this.transientBlobCache.close();
    }

    @Override
    public int getPort() {
        return this.permanentBlobCache.getPort();
    }
}

