/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.shims;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.shims.JettyShims;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.shims.SchedulerShim;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.AppenderSkeleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShimLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ShimLoader.class);
    public static final String HADOOP23VERSIONNAME = "0.23";
    private static volatile HadoopShims hadoopShims;
    private static JettyShims jettyShims;
    private static AppenderSkeleton eventCounter;
    private static HadoopThriftAuthBridge hadoopThriftAuthBridge;
    private static SchedulerShim schedulerShim;
    private static final HashMap<String, String> HADOOP_SHIM_CLASSES;
    private static final HashMap<String, String> EVENT_COUNTER_SHIM_CLASSES;
    private static final HashMap<String, String> HADOOP_THRIFT_AUTH_BRIDGE_CLASSES;
    private static final String SCHEDULER_SHIM_CLASSE = "org.apache.flink.table.store.shaded.org.apache.hadoop.hive.schshim.FairSchedulerShim";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HadoopShims getHadoopShims() {
        if (hadoopShims != null) return hadoopShims;
        Class<ShimLoader> clazz = ShimLoader.class;
        synchronized (ShimLoader.class) {
            if (hadoopShims != null) return hadoopShims;
            try {
                hadoopShims = ShimLoader.loadShims(HADOOP_SHIM_CLASSES, HadoopShims.class);
            }
            catch (Throwable t) {
                LOG.error("Error loading shims", t);
                throw new RuntimeException(t);
            }
            return hadoopShims;
        }
    }

    public static synchronized AppenderSkeleton getEventCounter() {
        if (eventCounter == null) {
            eventCounter = ShimLoader.loadShims(EVENT_COUNTER_SHIM_CLASSES, AppenderSkeleton.class);
        }
        return eventCounter;
    }

    public static synchronized HadoopThriftAuthBridge getHadoopThriftAuthBridge() {
        if (hadoopThriftAuthBridge == null) {
            hadoopThriftAuthBridge = ShimLoader.loadShims(HADOOP_THRIFT_AUTH_BRIDGE_CLASSES, HadoopThriftAuthBridge.class);
        }
        return hadoopThriftAuthBridge;
    }

    public static synchronized SchedulerShim getSchedulerShims() {
        if (schedulerShim == null) {
            schedulerShim = ShimLoader.createShim(SCHEDULER_SHIM_CLASSE, SchedulerShim.class);
        }
        return schedulerShim;
    }

    private static <T> T loadShims(Map<String, String> classMap, Class<T> xface) {
        String vers = ShimLoader.getMajorVersion();
        String className = classMap.get(vers);
        return ShimLoader.createShim(className, xface);
    }

    private static <T> T createShim(String className, Class<T> xface) {
        try {
            Class<?> clazz = Class.forName(className);
            return xface.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load shims in class " + className, e);
        }
    }

    public static String getMajorVersion() {
        String vers = VersionInfo.getVersion();
        String[] parts = vers.split("\\.");
        if (parts.length < 2) {
            throw new RuntimeException("Illegal Hadoop Version: " + vers + " (expected A.B.* format)");
        }
        switch (Integer.parseInt(parts[0])) {
            case 2: 
            case 3: {
                return HADOOP23VERSIONNAME;
            }
        }
        throw new IllegalArgumentException("Unrecognized Hadoop major version number: " + vers);
    }

    private ShimLoader() {
    }

    static {
        HADOOP_SHIM_CLASSES = new HashMap();
        HADOOP_SHIM_CLASSES.put(HADOOP23VERSIONNAME, "org.apache.flink.table.store.shaded.org.apache.hadoop.hive.shims.Hadoop23Shims");
        EVENT_COUNTER_SHIM_CLASSES = new HashMap();
        EVENT_COUNTER_SHIM_CLASSES.put(HADOOP23VERSIONNAME, "org.apache.hadoop.log.metrics.EventCounter");
        HADOOP_THRIFT_AUTH_BRIDGE_CLASSES = new HashMap();
        HADOOP_THRIFT_AUTH_BRIDGE_CLASSES.put(HADOOP23VERSIONNAME, "org.apache.flink.table.store.shaded.org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge23");
    }
}

