/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy;

import java.nio.charset.CharacterCodingException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveCharObjectInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyHiveChar
extends LazyPrimitive<LazyHiveCharObjectInspector, HiveCharWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyHiveChar.class);
    protected int maxLength = -1;

    public LazyHiveChar(LazyHiveCharObjectInspector oi) {
        super(oi);
        this.maxLength = ((CharTypeInfo)oi.getTypeInfo()).getLength();
        this.data = new HiveCharWritable();
    }

    public LazyHiveChar(LazyHiveChar copy) {
        super(copy);
        this.maxLength = copy.maxLength;
        this.data = new HiveCharWritable((HiveCharWritable)copy.data);
    }

    public void setValue(LazyHiveChar copy) {
        ((HiveCharWritable)this.data).set((HiveCharWritable)copy.data, this.maxLength);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (((LazyHiveCharObjectInspector)this.oi).isEscaped()) {
            Text textData = ((HiveCharWritable)this.data).getTextValue();
            LazyUtils.copyAndEscapeStringDataToText(bytes.getData(), start, length, ((LazyHiveCharObjectInspector)this.oi).getEscapeChar(), textData);
            ((HiveCharWritable)this.data).set(textData.toString(), this.maxLength);
            this.isNull = false;
        } else {
            String byteData = null;
            try {
                byteData = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
                ((HiveCharWritable)this.data).set(byteData, this.maxLength);
                this.isNull = false;
            }
            catch (CharacterCodingException e) {
                this.isNull = true;
                LOG.debug("Data not in the HiveChar data type range so converted to null.", (Throwable)e);
            }
        }
    }
}

