/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.connector.kafka.source;

import java.util.Properties;
import java.util.function.Function;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class KafkaSourceOptions {
    public static final ConfigOption<String> CLIENT_ID_PREFIX = ConfigOptions.key((String)"client.id.prefix").stringType().noDefaultValue().withDescription("The prefix to use for the Kafka consumers.");
    public static final ConfigOption<Long> PARTITION_DISCOVERY_INTERVAL_MS = ConfigOptions.key((String)"partition.discovery.interval.ms").longType().noDefaultValue().withDescription("The interval in milliseconds for the Kafka source to discover the new partitions. A non-positive value disables the partition discovery.");
    public static final ConfigOption<Boolean> REGISTER_KAFKA_CONSUMER_METRICS = ConfigOptions.key((String)"register.consumer.metrics").booleanType().defaultValue((Object)true).withDescription("Whether to register metrics of KafkaConsumer into Flink metric group");
    public static final ConfigOption<Boolean> COMMIT_OFFSETS_ON_CHECKPOINT = ConfigOptions.key((String)"commit.offsets.on.checkpoint").booleanType().defaultValue((Object)true).withDescription("Whether to commit consuming offset on checkpoint.");

    public static <T> T getOption(Properties props, ConfigOption<?> configOption, Function<String, T> parser) {
        String value = props.getProperty(configOption.key());
        return (T)(value == null ? configOption.defaultValue() : parser.apply(value));
    }
}

