/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;

public class ThrottleSettings {
    public static final String ELEMENT_INBOUND = "throttle-inbound";
    public static final String ELEMENT_OUTBOUND = "throttle-outbound";
    public static final String ELEMENT_POLICY = "policy";
    public static final String ELEMENT_DEST_FREQ = "max-frequency";
    public static final String ELEMENT_CLIENT_FREQ = "max-client-frequency";
    private static final int ERR_MSG_INVALID_INBOUND_POLICY = 11130;
    private static final int ERR_MSG_INVALID_INCOMING_CLENT_FREQ = 11131;
    private static final int ERR_MSG_INVALID_INCOMING_DEST_FREQ = 11132;
    private static final int ERR_MSG_INVALID_OUTGOING_CLIENT_FREQ = 11133;
    private static final int ERR_MSG_INVALID_OUTGOING_DEST_FREQ = 11134;
    private static final int ERR_MSG_INVALID_NEGATIVE_VALUE = 11135;
    private String destinationName;
    private int inClientMessagesPerSec;
    private int inDestinationMessagesPerSec;
    private int outClientMessagesPerSec;
    private int outDestinationMessagesPerSec;
    private Policy inPolicy = Policy.NONE;
    private Policy outPolicy = Policy.NONE;

    public static Policy parsePolicy(String policy) {
        if (Policy.NONE.toString().equalsIgnoreCase(policy)) {
            return Policy.NONE;
        }
        if (Policy.IGNORE.toString().equalsIgnoreCase(policy)) {
            return Policy.IGNORE;
        }
        if (Policy.ERROR.toString().equalsIgnoreCase(policy)) {
            return Policy.ERROR;
        }
        if (Policy.BUFFER.toString().equalsIgnoreCase(policy)) {
            return Policy.BUFFER;
        }
        if (Policy.CONFLATE.toString().equalsIgnoreCase(policy)) {
            return Policy.CONFLATE;
        }
        ConfigurationException ex = new ConfigurationException();
        throw ex;
    }

    public boolean isClientThrottleEnabled() {
        return this.isInboundClientThrottleEnabled() || this.isOutboundClientThrottleEnabled();
    }

    public boolean isInboundClientThrottleEnabled() {
        return this.inPolicy != Policy.NONE && this.getIncomingClientFrequency() > 0;
    }

    public boolean isOutboundClientThrottleEnabled() {
        return this.outPolicy != Policy.NONE && this.getOutgoingClientFrequency() > 0;
    }

    public boolean isDestinationThrottleEnabled() {
        return this.isInboundDestinationThrottleEnabled() || this.isOutboundDestinationThrottleEnabled();
    }

    public boolean isInboundDestinationThrottleEnabled() {
        return this.inPolicy != Policy.NONE && this.getIncomingDestinationFrequency() > 0;
    }

    public boolean isOutboundDestinationThrottleEnabled() {
        return this.outPolicy != Policy.NONE && this.getOutgoingDestinationFrequency() > 0;
    }

    public Policy getInboundPolicy() {
        return this.inPolicy;
    }

    public void setInboundPolicy(Policy inPolicy) {
        if (inPolicy != Policy.NONE && inPolicy != Policy.ERROR && inPolicy != Policy.IGNORE) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11130, new Object[]{inPolicy, this.destinationName});
            throw ex;
        }
        this.inPolicy = inPolicy;
    }

    public Policy getOutboundPolicy() {
        return this.outPolicy;
    }

    public void setOutboundPolicy(Policy outPolicy) {
        this.outPolicy = outPolicy;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public int getIncomingClientFrequency() {
        return this.inClientMessagesPerSec;
    }

    public void setIncomingClientFrequency(int n) {
        String name = "incoming client frequency";
        this.blockNegative(n, name);
        if (this.inDestinationMessagesPerSec > 0 && n > this.inDestinationMessagesPerSec) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11131, new Object[]{name, this.destinationName, n, this.inDestinationMessagesPerSec});
            throw ex;
        }
        this.inClientMessagesPerSec = n;
    }

    public int getIncomingDestinationFrequency() {
        return this.inDestinationMessagesPerSec;
    }

    public void setIncomingDestinationFrequency(int n) {
        String name = "The incoming destination frequency";
        this.blockNegative(n, name);
        if (this.inClientMessagesPerSec > 0 && n < this.inClientMessagesPerSec) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11132, new Object[]{name, this.destinationName, n, this.inClientMessagesPerSec});
            throw ex;
        }
        this.inDestinationMessagesPerSec = n;
    }

    public int getOutgoingClientFrequency() {
        return this.outClientMessagesPerSec;
    }

    public void setOutgoingClientFrequency(int n) {
        String name = "The outgoing client frequency";
        this.blockNegative(n, name);
        if (this.outDestinationMessagesPerSec > 0 && n > this.outDestinationMessagesPerSec) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11133, new Object[]{name, this.destinationName, n, this.outDestinationMessagesPerSec});
            throw ex;
        }
        this.outClientMessagesPerSec = n;
    }

    public int getOutgoingDestinationFrequency() {
        return this.outDestinationMessagesPerSec;
    }

    public void setOutgoingDestinationFrequency(int n) {
        String name = "The outgoing destination frequency";
        this.blockNegative(n, name);
        if (this.outClientMessagesPerSec > 0 && n < this.outClientMessagesPerSec) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11134, new Object[]{name, this.destinationName, n, this.outClientMessagesPerSec});
            throw ex;
        }
        this.outDestinationMessagesPerSec = n;
    }

    protected void blockNegative(int n, String name) {
        if (n < 0) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11135, new Object[]{name, this.destinationName});
            throw ex;
        }
    }

    public static enum Policy {
        NONE,
        ERROR,
        IGNORE,
        BUFFER,
        CONFLATE;

    }
}

