/*
 * Decompiled with CFR 0.152.
 */
package flash.graphics.g2d;

import flash.graphics.g2d.AbstractGraphics2D;
import flash.graphics.g2d.GraphicContext;
import flash.graphics.images.JPEGImage;
import flash.graphics.images.LosslessImage;
import flash.swf.builder.tags.DefineBitsLosslessBuilder;
import flash.swf.builder.tags.DefineShapeBuilder;
import flash.swf.builder.tags.ImageShapeBuilder;
import flash.swf.builder.types.MatrixBuilder;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineBitsLossless;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.PlaceObject;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.TagList;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;

public class SpriteGraphics2D
extends AbstractGraphics2D {
    protected TagList defineTags;
    protected int depth = 1;
    protected int width;
    protected int height;
    protected Rect bounds;

    public SpriteGraphics2D(int width, int height) {
        super(new GraphicContext(width, height));
        this.width = width;
        this.height = height;
        this.init();
    }

    public SpriteGraphics2D() {
        super(new GraphicContext());
        this.init();
    }

    private void init() {
        this.defineTags = new TagList();
        this.graphicContext.validateTransformStack();
        this.bounds = new Rect();
    }

    private SpriteGraphics2D(SpriteGraphics2D swf2d) {
        super((GraphicContext)swf2d.graphicContext.clone());
        this.bounds = new Rect();
        this.defineTags = swf2d.getTags();
    }

    public void draw(Shape shape) {
        this.defineShape(shape, true, false);
    }

    public void fill(Shape shape) {
        this.defineShape(shape, false, true);
    }

    private void defineShape(Shape shape, boolean draw, boolean fill) {
        Matrix matrix;
        Point2D oldPen = null;
        boolean isGradient = false;
        if (fill && SpriteGraphics2D.isGradientFill(this.graphicContext.getPaint())) {
            isGradient = true;
        }
        if (isGradient) {
            shape = this.graphicContext.getTransform().createTransformedShape(shape);
            oldPen = this.graphicContext.setPen(SpriteGraphics2D.getShapeStart(shape));
        }
        DefineShapeBuilder builder = new DefineShapeBuilder(shape, this.graphicContext, draw, fill);
        DefineShape ds3 = (DefineShape)builder.build();
        this.defineTags.defineShape3(ds3);
        if (isGradient) {
            double originX = this.graphicContext.getPen().getX();
            double originY = this.graphicContext.getPen().getY();
            matrix = MatrixBuilder.getTranslateInstance(originX, originY);
        } else {
            matrix = MatrixBuilder.build(this.graphicContext.getTransform());
        }
        this.applyBounds(ds3.bounds.xMin + matrix.translateX, ds3.bounds.yMin + matrix.translateY, ds3.bounds.xMax + matrix.translateX, ds3.bounds.yMax + matrix.translateY);
        PlaceObject po2 = new PlaceObject(26);
        po2.setMatrix(matrix);
        po2.setRef(ds3);
        po2.depth = this.depth++;
        if (isGradient) {
            this.graphicContext.setPen(oldPen);
        }
        this.defineTags.placeObject2(po2);
    }

    public void drawString(String str, float x, float y) {
        this.drawStringAsShape(str, x, y);
    }

    public void drawString(String str, int x, int y) {
        super.drawString(str, x, y);
    }

    public boolean drawImage(Image image, AffineTransform at, ImageObserver obs) {
        if (image != null) {
            LosslessImage losslessImage = new LosslessImage(image);
            int width = losslessImage.getWidth();
            int height = losslessImage.getHeight();
            DefineBitsLossless defineBits = DefineBitsLosslessBuilder.build(losslessImage.getPixels(), width, height);
            this.defineTags.defineBitsLossless2(defineBits);
            DefineShape ds3 = ImageShapeBuilder.buildImage(defineBits, defineBits.width, defineBits.height);
            this.defineTags.defineShape3(ds3);
            this.applyBounds(ds3.bounds.xMin, ds3.bounds.yMin, ds3.bounds.xMax, ds3.bounds.yMax);
            PlaceObject po2 = new PlaceObject(26);
            po2.setMatrix(MatrixBuilder.build(at));
            po2.setRef(ds3);
            po2.depth = this.depth++;
            this.defineTags.placeObject2(po2);
        }
        return false;
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        AffineTransform at = this.graphicContext.getTransform();
        at.translate(x, y);
        return this.drawImage(image, at, observer);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        AffineTransform at = this.graphicContext.getTransform();
        at.translate(x, y);
        double sx = (double)width / (double)image.getWidth(observer);
        double sy = (double)height / (double)image.getHeight(observer);
        at.scale(sx, sy);
        return this.drawImage(image, at, observer);
    }

    public void drawNamedImage(Image image, String name) {
        if (image != null) {
            LosslessImage losslessImage = new LosslessImage(image);
            int width = losslessImage.getWidth();
            int height = losslessImage.getHeight();
            DefineBitsLossless defineBits = DefineBitsLosslessBuilder.build(losslessImage.getPixels(), width, height);
            this.defineTags.defineBitsLossless2(defineBits);
            DefineShape ds3 = ImageShapeBuilder.buildImage(defineBits, defineBits.width, defineBits.height);
            this.defineTags.defineShape3(ds3);
            this.applyBounds(ds3.bounds.xMin, ds3.bounds.yMin, ds3.bounds.xMax, ds3.bounds.yMax);
            PlaceObject po2 = new PlaceObject(ds3, this.depth++);
            po2.setMatrix(MatrixBuilder.build(this.graphicContext.getTransform()));
            po2.setName(name);
            this.defineTags.placeObject2(po2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawJPEG(InputStream inputStream, int length, int width, int height, String name) throws IOException {
        if (inputStream != null) {
            try {
                JPEGImage image = new JPEGImage(inputStream, length);
                DefineBits defineBits = new DefineBits(21);
                defineBits.data = image.getData();
                this.defineTags.defineBitsJPEG2(defineBits);
                DefineShape ds3 = ImageShapeBuilder.buildImage(defineBits, width, height);
                this.defineTags.defineShape3(ds3);
                this.applyBounds(ds3.bounds.xMin, ds3.bounds.yMin, ds3.bounds.xMax, ds3.bounds.yMax);
                PlaceObject po2 = new PlaceObject(ds3, this.depth++);
                po2.setMatrix(MatrixBuilder.build(this.graphicContext.getTransform()));
                po2.setName(name);
                this.defineTags.placeObject2(po2);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Graphics create() {
        return new SpriteGraphics2D(this);
    }

    public TagList getTags() {
        return this.defineTags;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public DefineSprite defineSprite(String name) {
        DefineSprite defineSprite = new DefineSprite();
        defineSprite.framecount = 1;
        defineSprite.tagList = this.defineTags;
        defineSprite.name = name;
        return defineSprite;
    }

    private static boolean isGradientFill(Paint paint) {
        return paint != null && (paint instanceof GradientPaint || paint.getClass().getName().equals("org.apache.flex.forks.batik.ext.awt.MultipleGradientPaint"));
    }

    private static Point2D getShapeStart(Shape shape) {
        if (shape != null) {
            Rectangle2D bounds = shape.getBounds2D();
            return new Point2D.Double(bounds.getMinX(), bounds.getMinY());
        }
        return new Point2D.Double(0.0, 0.0);
    }

    private void applyBounds(int x1, int y1, int x2, int y2) {
        if (x1 < this.bounds.xMin) {
            this.bounds.xMin = x1;
        }
        if (y1 < this.bounds.yMin) {
            this.bounds.yMin = y1;
        }
        if (x1 > this.bounds.xMax) {
            this.bounds.xMax = x1;
        }
        if (y1 > this.bounds.yMax) {
            this.bounds.yMax = y1;
        }
        if (x2 < this.bounds.xMin) {
            this.bounds.xMin = x2;
        }
        if (y2 < this.bounds.yMin) {
            this.bounds.yMin = y2;
        }
        if (x2 > this.bounds.xMax) {
            this.bounds.xMax = x2;
        }
        if (y2 > this.bounds.yMax) {
            this.bounds.yMax = y2;
        }
    }

    public Rect getBounds() {
        return this.bounds;
    }
}

