/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.util.Qualifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Names {
    private static int tables;
    private static int lookups;
    private static int misses;
    private static int collisions;
    private static int named_collisions;
    private static int entries;
    private static int grows;
    private static boolean profile;
    private String[] name;
    private ObjectValue[] namespace;
    private int[] slot;
    private byte[] type;
    private int[] next;
    private int namesUsed;
    private int[] hashTable;
    private int hashTableMask;
    public static final int GET_NAMES = 0;
    public static final int SET_NAMES = 1;
    public static final int VAR_NAMES = 2;
    public static final int METHOD_NAMES = 3;
    public static final int LOCAL_METHOD_NAMES = 4;
    private static final int INITIAL_CAPACITY = 8;
    public static final Names EMPTY_NAMES;

    public Names() {
        if (profile) {
            ++tables;
        }
    }

    public void dump() {
        for (int i = 0; i < this.name.length; ++i) {
            System.out.println(this.name[i] + " '" + (this.namespace[i] == null ? "" : this.namespace[i].name + "' " + this.namespace[i].getNamespaceKind()));
        }
    }

    private int hash(String name) {
        assert (name.intern() == name);
        return name.hashCode() & this.hashTableMask;
    }

    private int find(String name, int ty) {
        int i = this.hash(name);
        if (profile) {
            ++lookups;
        }
        int id = this.hashTable[i];
        while (id != -1) {
            if (this.name[id] == name && this.type[id] == ty) {
                return id;
            }
            if (profile) {
                ++collisions;
                if (this.name[id] == name) {
                    ++named_collisions;
                }
            }
            id = this.next[id];
        }
        if (profile) {
            ++misses;
            --collisions;
        }
        return -1;
    }

    private int enter(String name, ObjectValue namespace, int type, int hash) {
        if (profile) {
            ++entries;
        }
        int id = this.namesUsed;
        if (this.namesUsed >= this.name.length) {
            this.growNames();
        }
        this.name[id] = name;
        this.namespace[id] = namespace;
        this.next[id] = this.hashTable[hash];
        this.type[id] = (byte)type;
        this.slot[id] = -1;
        this.hashTable[hash] = id;
        ++this.namesUsed;
        return id;
    }

    private int find(String name, ObjectValue namespace, int type, boolean enter) {
        int hv = this.hash(name);
        int id = this.hashTable[hv];
        if (profile) {
            ++lookups;
        }
        if (id == -1) {
            if (enter) {
                return this.enter(name, namespace, type, hv);
            }
            if (profile) {
                ++misses;
            }
            return -1;
        }
        String namespaceName = namespace.name;
        byte namespaceKind = namespace.getNamespaceKind();
        assert (namespaceName == namespaceName.intern());
        do {
            if (this.name[id] == name && this.type[id] == type && namespaceName == this.namespace[id].name && namespaceKind == this.namespace[id].getNamespaceKind()) {
                return id;
            }
            if (!profile) continue;
            ++collisions;
            if (this.name[id] != name) continue;
            ++named_collisions;
        } while ((id = this.next[id]) != -1);
        if (enter) {
            return this.enter(name, namespace, type, hv);
        }
        if (profile) {
            ++misses;
        }
        return -1;
    }

    public int size() {
        if (this == EMPTY_NAMES) {
            return 0;
        }
        return this.namesUsed;
    }

    private boolean isFull() {
        return 5 * (this.namesUsed + 1) >= this.capacity() * 4;
    }

    private final int capacity() {
        return this.hashTable != null ? this.hashTable.length : 0;
    }

    private int put(String name, ObjectValue namespace, int type) {
        if (this.hashTable == null || this.isFull()) {
            this.grow();
        }
        return this.find(name, namespace, type, true);
    }

    public void putMask(String name, ObjectValue namespace, int type) {
        this.put(name, namespace, type);
    }

    public void put(String name, ObjectValue namespace, int type, int slot) {
        int id = this.put(name, namespace, type);
        this.slot[id] = slot;
    }

    public boolean containsKey(String name, int type) {
        if (this == EMPTY_NAMES || this.hashTable == null) {
            return false;
        }
        int id = this.find(name, type);
        boolean hasIt = id != -1 && this.slot[id] != -1;
        return hasIt;
    }

    public int get(String name, ObjectValue namespace, int type) {
        if (this == EMPTY_NAMES || this.hashTable == null) {
            return -1;
        }
        int id = this.find(name, namespace, type, false);
        int slot = id != -1 ? this.slot[id] : -1;
        return slot;
    }

    public Set<Map.Entry<String, Qualifiers>> entrySet(int type) {
        TreeMap<String, Qualifiers> map = new TreeMap<String, Qualifiers>();
        for (int i = 0; i < this.namesUsed; ++i) {
            String n = this.name[i];
            if (n == null || this.type[i] != type) continue;
            Qualifiers q = (Qualifiers)map.get(n);
            if (q == null) {
                q = new Qualifiers();
                map.put(n, q);
            }
            q.put(this.namespace[i], this.slot[i]);
        }
        return map.entrySet();
    }

    public boolean exist(String name, int type) {
        if (this == EMPTY_NAMES) {
            return false;
        }
        int hv = this.hash(name);
        int id = this.hashTable[hv];
        while (id != -1) {
            if (this.name[id] == name && this.type[id] == type) {
                return true;
            }
            id = this.next[id];
        }
        return false;
    }

    public Qualifiers get(String name, int type) {
        if (this == EMPTY_NAMES) {
            return null;
        }
        Qualifiers q = null;
        int hv = this.hash(name);
        int id = this.hashTable[hv];
        while (id != -1) {
            if (this.name[id] == name && this.type[id] == type) {
                if (q == null) {
                    q = new Qualifiers();
                }
                q.put(this.namespace[id], this.slot[id]);
                if (profile) {
                    ++lookups;
                }
            } else if (profile) {
                ++collisions;
                if (this.name[id] == name) {
                    ++named_collisions;
                }
            }
            id = this.next[id];
        }
        if (profile && q == null) {
            ++misses;
        }
        return q;
    }

    public void putAll(Names names) {
        for (int i = 0; i < names.namesUsed; ++i) {
            this.put(names.name[i], names.namespace[i], names.type[i], names.slot[i]);
        }
    }

    public boolean containsKey(String name, ObjectValue namespace, int type) {
        if (this == EMPTY_NAMES || this.hashTable == null) {
            return false;
        }
        int id = this.find(name, namespace, type, false);
        boolean hasIt = id != -1 && this.slot[id] != -1;
        return hasIt;
    }

    private void newHashTable(int size) {
        this.hashTable = new int[size];
        this.hashTableMask = this.hashTable.length - 1;
        for (int i = 0; i < this.hashTable.length; ++i) {
            this.hashTable[i] = -1;
        }
    }

    private void growNames() {
        if (this.name == null) {
            this.name = new String[8];
            this.namespace = new ObjectValue[8];
            this.slot = new int[8];
            this.next = new int[8];
            this.type = new byte[8];
            return;
        }
        int l = this.name.length < 256 ? this.name.length * 2 : this.name.length + 256;
        String[] newName = new String[l];
        ObjectValue[] newNamespace = new ObjectValue[l];
        int[] newSlot = new int[l];
        int[] newNext = new int[l];
        byte[] newType = new byte[l];
        for (int i = 0; i < this.namesUsed; ++i) {
            newName[i] = this.name[i];
            newNamespace[i] = this.namespace[i];
            newSlot[i] = this.slot[i];
            newType[i] = this.type[i];
            newNext[i] = this.next[i];
        }
        this.name = newName;
        this.namespace = newNamespace;
        this.slot = newSlot;
        this.type = newType;
        this.next = newNext;
    }

    private void grow() {
        if (this.hashTable == null) {
            this.newHashTable(8);
            this.growNames();
            return;
        }
        this.newHashTable(this.capacity() * 2);
        if (profile) {
            ++grows;
        }
        int i = 0;
        while (i < this.namesUsed) {
            int hv = this.hash(this.name[i]);
            this.next[i] = this.hashTable[hv];
            this.hashTable[hv] = i++;
        }
    }

    public static int getTypeFromKind(int kind) {
        switch (kind) {
            case -79: {
                return 0;
            }
            case -99: {
                return 1;
            }
            case -112: {
                return 2;
            }
        }
        return 3;
    }

    public String getName(int i) {
        return this.name[i];
    }

    public ObjectValue getNamespace(int i) {
        return this.namespace[i];
    }

    public int getSlot(int i) {
        return this.slot[i];
    }

    public int getType(int i) {
        return this.type[i];
    }

    public int hasNext(int index) {
        if (index < this.namesUsed) {
            return index;
        }
        return -1;
    }

    static {
        profile = false;
        EMPTY_NAMES = new Names();
    }
}

