/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.memoryusage.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageCommand;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageConfigurator;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsagePanel;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private MemoryUsageSupport support;

    public void start(BundleContext bundleContext) {
        this.support = new MemoryUsageSupport(bundleContext);
        new AbstractServiceFactory(bundleContext, null, new String[]{"org.apache.felix.shell.Command"}){

            @Override
            protected Object createObject() {
                return new MemoryUsageCommand(Activator.this.support);
            }
        };
        Hashtable<String, String> pluginProps = new Hashtable<String, String>();
        ((Dictionary)pluginProps).put("felix.webconsole.label", "memoryusage");
        ((Dictionary)pluginProps).put("felix.webconsole.title", "%dump.title");
        ((Dictionary)pluginProps).put("felix.webconsole.category", "Web Console");
        ((Dictionary)pluginProps).put("felix.inventory.printer.name", "memoryusage");
        ((Dictionary)pluginProps).put("felix.inventory.printer.title", "Memory Usage");
        new AbstractServiceFactory(bundleContext, pluginProps, new String[]{"jakarta.servlet.Servlet", "org.apache.felix.inventory.InventoryPrinter"}){

            @Override
            public Object createObject() {
                return new MemoryUsagePanel(Activator.this.support);
            }
        };
        Hashtable<String, String> cmProps = new Hashtable<String, String>();
        ((Dictionary)cmProps).put("service.pid", "org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageConfigurator");
        new AbstractServiceFactory(bundleContext, cmProps, new String[]{"org.osgi.service.cm.ManagedService"}){

            @Override
            public Object createObject() {
                return new MemoryUsageConfigurator(Activator.this.support);
            }
        };
    }

    public void stop(BundleContext bundleContext) {
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
    }

    private static abstract class AbstractServiceFactory
    implements ServiceFactory {
        private int counter;
        private Object service;

        public AbstractServiceFactory(BundleContext context, Dictionary<String, Object> properties, String ... serviceNames) {
            if (properties == null) {
                properties = new Hashtable<String, Object>();
            }
            properties.put("service.description", "Memory Usage (" + serviceNames[0] + ")");
            properties.put("service.vendor", "Apache Software Foundation");
            context.registerService(serviceNames, (Object)this, properties);
        }

        public synchronized void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            --this.counter;
            if (this.counter <= 0) {
                service = null;
            }
        }

        public synchronized Object getService(Bundle bundle, ServiceRegistration registration) {
            ++this.counter;
            if (this.service == null) {
                this.service = this.createObject();
            }
            return this.service;
        }

        protected abstract Object createObject();
    }
}

