/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.discovery;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.felix.upnp.tester.Activator;
import org.apache.felix.upnp.tester.discovery.DeviceNode;
import org.apache.felix.upnp.tester.discovery.DeviceNodeListener;
import org.apache.felix.upnp.tester.gui.LogPanel;
import org.apache.felix.upnp.tester.gui.Util;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class RootDeviceListener
implements ServiceListener {
    private ArrayList devices = new ArrayList();
    private DeviceNodeListener listener;
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPDevice;

    public void setDeviceNodeListener(DeviceNodeListener listener) {
        this.listener = listener;
    }

    public synchronized void addNewDevice(ServiceReference sr) {
        DeviceNode tree;
        DeviceNode handle;
        Iterator list;
        LogPanel.log("adding device:" + sr.getProperty("UPnP.device.friendlyName"));
        DeviceNode node = new DeviceNode(sr);
        if (node.isRoot() && node.isLeaf()) {
            this.listener.deviceDetected(node);
            return;
        }
        if (!node.isLeaf()) {
            list = this.devices.iterator();
            handle = null;
            while (list.hasNext()) {
                tree = (DeviceNode)list.next();
                handle = node.isAttachable(tree);
                if (handle == null) continue;
                handle.attach(tree);
                list.remove();
                this.monitorDevices();
                if (!node.isRoot() || !node.isComplete()) continue;
                this.listener.deviceDetected(node);
                return;
            }
        }
        if (!node.isRoot()) {
            list = this.devices.iterator();
            handle = null;
            while (list.hasNext()) {
                tree = (DeviceNode)list.next();
                handle = tree.isAttachable(node);
                if (handle == null) continue;
                handle.attach(node);
                if (tree.isRoot() && tree.isComplete()) {
                    list.remove();
                    this.monitorDevices();
                    this.listener.deviceDetected(tree);
                }
                return;
            }
        }
        this.devices.add(node);
        this.monitorDevices();
    }

    private void monitorDevices() {
        LogPanel.status("Pending Devices: " + this.devices.size());
    }

    public void removeDevice(ServiceReference sr) {
        DeviceNode node = new DeviceNode(sr);
        if (node.isRoot()) {
            LogPanel.log("removing root device ..." + sr.getProperty("UPnP.device.friendlyName"));
            this.listener.rootDeviceUnplugged(node.toString());
            return;
        }
    }

    public void serviceChanged(ServiceEvent e) {
        switch (e.getType()) {
            case 1: {
                this.addNewDevice(e.getServiceReference());
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.removeDevice(e.getServiceReference());
            }
        }
    }

    public void activate() {
        try {
            Activator.context.addServiceListener((ServiceListener)this, "(&(objectClass=" + (class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = RootDeviceListener.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName() + ")" + "(" + "UPnP.device.UDN" + "=*)" + ")");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        ServiceReference[] roots = null;
        try {
            roots = Activator.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = RootDeviceListener.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), "(&(objectClass=" + (class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = RootDeviceListener.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName() + ")" + "(" + "UPnP.device.UDN" + "=*)" + ")");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if (roots != null) {
            for (int i = 0; i < roots.length; ++i) {
                this.addNewDevice((ServiceReference)roots[i]);
            }
        }
    }

    public void deactive() {
        Activator.context.removeServiceListener((ServiceListener)this);
    }

    public void checkIncompleteDevice() {
        if (this.devices.size() == 0) {
            LogPanel.log("[check incomplete device] no pending devices !");
            return;
        }
        Iterator list = this.devices.iterator();
        while (list.hasNext()) {
            LogPanel.log("[check incomplete device] ");
            LogPanel.log("------- device -------- ");
            DeviceNode tree = (DeviceNode)list.next();
            RootDeviceListener.printProperties(tree.getReference());
        }
    }

    public static void checkErrataDevice() {
        ServiceReference[] allUPnPDevice = null;
        ServiceReference[] UPnPbaseDriverDevice = null;
        try {
            allUPnPDevice = Activator.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = RootDeviceListener.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), "(&(UPnP.export=*)(objectClass=" + (class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = RootDeviceListener.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName() + ")" + ")");
            UPnPbaseDriverDevice = Activator.context.getServiceReferences((class$org$osgi$service$upnp$UPnPDevice == null ? (class$org$osgi$service$upnp$UPnPDevice = RootDeviceListener.class$("org.osgi.service.upnp.UPnPDevice")) : class$org$osgi$service$upnp$UPnPDevice).getName(), "(&(UPnP.export=*)(DEVICE_CATEGORY=UPnP)(UPnP.device.UDN=*)(UPnP.device.friendlyName=*)(UPnP.device.manufacturer=*)(UPnP.device.modelName=*)(UPnP.device.type=*)(!(UPnP.device.parentUDN=*)))");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if (allUPnPDevice != null) {
            if (UPnPbaseDriverDevice != null) {
                if (allUPnPDevice.length == UPnPbaseDriverDevice.length) {
                    LogPanel.log("---- Check Errata Device ----");
                    LogPanel.log("All registered Devices have mandatory properties specified");
                    LogPanel.log("--------  End Check  --------");
                } else if (allUPnPDevice.length > UPnPbaseDriverDevice.length) {
                    RootDeviceListener.printErrataDevice(allUPnPDevice, UPnPbaseDriverDevice);
                }
            } else {
                RootDeviceListener.printErrataDevice(allUPnPDevice, UPnPbaseDriverDevice);
            }
        }
    }

    public static void printErrataDevice(ServiceReference[] allUPnPDevice, ServiceReference[] UPnPbaseDriverDevice) {
        LogPanel.log("---- Check Errata Device ----");
        for (int i = 0; i < allUPnPDevice.length; ++i) {
            if (RootDeviceListener.isPresent(allUPnPDevice[i], UPnPbaseDriverDevice)) continue;
            LogPanel.log("---- Device ----");
            RootDeviceListener.printProperties(allUPnPDevice[i]);
        }
        LogPanel.log("--------  End Check  --------");
    }

    public static boolean isPresent(ServiceReference sr, ServiceReference[] list) {
        Object s = Activator.context.getService(sr);
        for (int i = 0; i < list.length; ++i) {
            Object item = Activator.context.getService(list[i]);
            if (s == item) {
                Activator.context.ungetService(sr);
                Activator.context.ungetService(list[i]);
                return true;
            }
            Activator.context.ungetService(list[i]);
        }
        Activator.context.ungetService(sr);
        return false;
    }

    public static void printProperties(ServiceReference service) {
        String[] properties = service.getPropertyKeys();
        if (properties == null) {
            LogPanel.log("properties are null");
        } else {
            for (int j = 0; j < properties.length; ++j) {
                LogPanel.log(properties[j] + "=" + Util.justString(service.getProperty(properties[j])));
            }
        }
        if (service.getProperty("UPnP.device.UDN") == null) {
            LogPanel.log("[Warning] missing property: UPnP.device.UDN");
        }
        if (service.getProperty("UPnP.device.friendlyName") == null) {
            LogPanel.log("[Warning] missing property: UPnP.device.friendlyName");
        }
        if (service.getProperty("UPnP.device.manufacturer") == null) {
            LogPanel.log("[Warning] missing property: UPnP.device.manufacturer");
        }
        if (service.getProperty("UPnP.device.modelName") == null) {
            LogPanel.log("[Warning] missing property: UPnP.device.modelName");
        }
        if (service.getProperty("UPnP.device.type") == null) {
            LogPanel.log("[Warning] missing property: UPnP.device.type");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

