/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.metadata.Element;

public class Metadatas {
    private Metadatas() {
    }

    public static String getComponentType(Element meta) {
        return meta.getAttribute("classname");
    }

    public static void findFields(List<String> fields, Element metadata) {
        String field = metadata.getAttribute("field");
        if (field != null && !fields.contains(field)) {
            fields.add(field);
        }
        for (Element element : metadata.getElements()) {
            Metadatas.findFields(fields, element);
        }
    }

    public static Set<String> findReferredPackages(Element metadata) {
        HashSet<String> packages = new HashSet<String>();
        Set<String> specifications = Metadatas.findAttributes(metadata, "specification");
        for (String specification : specifications) {
            String name = Metadatas.getPackageName(specification);
            if (name == null) continue;
            packages.add(name);
        }
        return packages;
    }

    private static String getPackageName(String specification) {
        int last = specification.lastIndexOf(46);
        if (last != -1) {
            return specification.substring(0, last);
        }
        return null;
    }

    public static Set<String> findAttributes(Element metadata, String attributeName) {
        HashSet<String> referred = new HashSet<String>();
        if (metadata.containsAttribute(attributeName)) {
            referred.add(metadata.getAttribute(attributeName));
        }
        for (Element elem : metadata.getElements()) {
            Set<String> found = Metadatas.findAttributes(elem, attributeName);
            referred.addAll(found);
        }
        return referred;
    }
}

