/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.WritePendingException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.CloseState;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.FailureFrame;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2Stream
extends IdleTimeout
implements IStream,
Callback,
Dumpable {
    private static final Logger LOG = Log.getLogger(HTTP2Stream.class);
    private final AtomicReference<Object> attachment = new AtomicReference();
    private final AtomicReference<ConcurrentMap<String, Object>> attributes = new AtomicReference();
    private final AtomicReference<CloseState> closeState = new AtomicReference<CloseState>(CloseState.NOT_CLOSED);
    private final AtomicInteger sendWindow = new AtomicInteger();
    private final AtomicInteger recvWindow = new AtomicInteger();
    private final long timeStamp = System.nanoTime();
    private final ISession session;
    private final int streamId;
    private final boolean local;
    private Callback sendCallback;
    private Throwable failure;
    private boolean localReset;
    private boolean remoteReset;
    private Stream.Listener listener;
    private long dataLength;
    private boolean committed;

    public HTTP2Stream(Scheduler scheduler, ISession session, int streamId, boolean local) {
        super(scheduler);
        this.session = session;
        this.streamId = streamId;
        this.local = local;
        this.dataLength = Long.MIN_VALUE;
    }

    @Override
    public int getId() {
        return this.streamId;
    }

    @Override
    public Object getAttachment() {
        return this.attachment.get();
    }

    @Override
    public void setAttachment(Object attachment) {
        this.attachment.set(attachment);
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public ISession getSession() {
        return this.session;
    }

    @Override
    public void send(IStream.FrameList frameList, Callback callback) {
        if (this.startWrite(callback)) {
            this.session.frames(this, frameList.getFrames(), this);
        }
    }

    @Override
    public void headers(HeadersFrame frame, Callback callback) {
        this.send(new IStream.FrameList(frame), callback);
    }

    @Override
    public void push(PushPromiseFrame frame, Promise<Stream> promise, Stream.Listener listener) {
        this.session.push(this, promise, frame, listener);
    }

    @Override
    public void data(DataFrame frame, Callback callback) {
        if (this.startWrite(callback)) {
            this.session.data(this, this, frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(ResetFrame frame, Callback callback) {
        Throwable resetFailure = null;
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            if (this.isReset()) {
                resetFailure = this.failure;
            } else {
                this.localReset = true;
                this.failure = new EOFException("reset");
            }
        }
        if (resetFailure != null) {
            callback.failed(resetFailure);
        } else {
            ((HTTP2Session)this.session).reset(this, frame, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startWrite(Callback callback) {
        Throwable failure;
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            failure = this.failure;
            if (failure == null && this.sendCallback == null) {
                this.sendCallback = callback;
                return true;
            }
        }
        if (failure == null) {
            failure = new WritePendingException();
        }
        callback.failed(failure);
        return false;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes().get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes().put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes().remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReset() {
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            return this.localReset || this.remoteReset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFailed() {
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            return this.failure != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResetOrFailed() {
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            return this.isReset() || this.isFailed();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closeState.get() == CloseState.CLOSED;
    }

    @Override
    public boolean isRemotelyClosed() {
        CloseState state = this.closeState.get();
        return state == CloseState.REMOTELY_CLOSED || state == CloseState.CLOSING || state == CloseState.CLOSED;
    }

    public boolean isLocallyClosed() {
        return this.closeState.get() == CloseState.LOCALLY_CLOSED;
    }

    @Override
    public void commit() {
        this.committed = true;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    protected void onIdleExpired(TimeoutException timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Idle timeout {}ms expired on {}", this.getIdleTimeout(), this);
        }
        if (this.notifyIdleTimeout(this, timeout)) {
            this.reset(new ResetFrame(this.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
    }

    private ConcurrentMap<String, Object> attributes() {
        ConcurrentMap<String, Object> map = this.attributes.get();
        if (map == null && !this.attributes.compareAndSet(null, map = new ConcurrentHashMap<String, Object>())) {
            map = this.attributes.get();
        }
        return map;
    }

    @Override
    public Stream.Listener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(Stream.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void process(Frame frame, Callback callback) {
        this.notIdle();
        switch (frame.getType()) {
            case PREFACE: {
                this.onNewStream(callback);
                break;
            }
            case HEADERS: {
                this.onHeaders((HeadersFrame)frame, callback);
                break;
            }
            case DATA: {
                this.onData((DataFrame)frame, callback);
                break;
            }
            case RST_STREAM: {
                this.onReset((ResetFrame)frame, callback);
                break;
            }
            case PUSH_PROMISE: {
                this.onPush((PushPromiseFrame)frame, callback);
                break;
            }
            case WINDOW_UPDATE: {
                this.onWindowUpdate((WindowUpdateFrame)frame, callback);
                break;
            }
            case FAILURE: {
                this.onFailure((FailureFrame)frame, callback);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void onNewStream(Callback callback) {
        this.notifyNewStream(this);
        callback.succeeded();
    }

    private void onHeaders(HeadersFrame frame, Callback callback) {
        MetaData metaData = frame.getMetaData();
        if (metaData.isRequest() || metaData.isResponse()) {
            HttpFields fields = metaData.getFields();
            long length = -1L;
            if (fields != null) {
                length = fields.getLongField(HttpHeader.CONTENT_LENGTH.asString());
            }
            this.dataLength = length >= 0L ? length : Long.MIN_VALUE;
        }
        callback.succeeded();
    }

    private void onData(DataFrame frame, Callback callback) {
        if (this.isRemotelyClosed()) {
            this.reset(new ResetFrame(this.streamId, ErrorCode.STREAM_CLOSED_ERROR.code), Callback.NOOP);
            callback.failed(new EOFException("stream_closed"));
            return;
        }
        if (this.isReset()) {
            callback.failed(new IOException("stream_reset"));
            return;
        }
        if (this.dataLength != Long.MIN_VALUE) {
            this.dataLength -= (long)frame.remaining();
            if (this.dataLength < 0L || frame.isEndStream() && this.dataLength != 0L) {
                this.reset(new ResetFrame(this.streamId, ErrorCode.PROTOCOL_ERROR.code), Callback.NOOP);
                callback.failed(new IOException("invalid_data_length"));
                return;
            }
        }
        boolean closed = this.updateClose(frame.isEndStream(), CloseState.Event.RECEIVED);
        this.notifyData(this, frame, callback);
        if (closed) {
            this.session.removeStream(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReset(ResetFrame frame, Callback callback) {
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            this.remoteReset = true;
            this.failure = new EofException("reset");
        }
        this.close();
        if (this.session.removeStream(this)) {
            this.notifyReset(this, frame, callback);
        } else {
            callback.succeeded();
        }
    }

    private void onPush(PushPromiseFrame frame, Callback callback) {
        this.updateClose(true, CloseState.Event.AFTER_SEND);
        callback.succeeded();
    }

    private void onWindowUpdate(WindowUpdateFrame frame, Callback callback) {
        callback.succeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFailure(FailureFrame frame, Callback callback) {
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            this.failure = frame.getFailure();
        }
        this.close();
        if (this.session.removeStream(this)) {
            this.notifyFailure(this, frame, callback);
        } else {
            callback.succeeded();
        }
    }

    @Override
    public boolean updateClose(boolean update, CloseState.Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update close for {} update={} event={}", new Object[]{this, update, event});
        }
        if (!update) {
            return false;
        }
        switch (event) {
            case RECEIVED: {
                return this.updateCloseAfterReceived();
            }
            case BEFORE_SEND: {
                return this.updateCloseBeforeSend();
            }
            case AFTER_SEND: {
                return this.updateCloseAfterSend();
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean updateCloseAfterReceived() {
        block5: while (true) {
            current = this.closeState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$http2$CloseState[current.ordinal()]) {
                case 1: {
                    if (!this.closeState.compareAndSet(current, CloseState.REMOTELY_CLOSED)) continue block5;
                    return false;
                }
                case 2: {
                    if (this.closeState.compareAndSet(current, CloseState.CLOSING)) ** break;
                    continue block5;
                    this.updateStreamCount(0, 1);
                    return false;
                }
                case 3: {
                    this.close();
                    return true;
                }
            }
            break;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean updateCloseBeforeSend() {
        block4: while (true) {
            current = this.closeState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$http2$CloseState[current.ordinal()]) {
                case 1: {
                    if (!this.closeState.compareAndSet(current, CloseState.LOCALLY_CLOSING)) continue block4;
                    return false;
                }
                case 4: {
                    if (this.closeState.compareAndSet(current, CloseState.CLOSING)) ** break;
                    continue block4;
                    this.updateStreamCount(0, 1);
                    return false;
                }
            }
            break;
        }
        return false;
    }

    private boolean updateCloseAfterSend() {
        block4: while (true) {
            CloseState current = this.closeState.get();
            switch (current) {
                case NOT_CLOSED: 
                case LOCALLY_CLOSING: {
                    if (!this.closeState.compareAndSet(current, CloseState.LOCALLY_CLOSED)) continue block4;
                    return false;
                }
                case REMOTELY_CLOSED: 
                case CLOSING: {
                    this.close();
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public int getSendWindow() {
        return this.sendWindow.get();
    }

    public int getRecvWindow() {
        return this.recvWindow.get();
    }

    @Override
    public int updateSendWindow(int delta) {
        return this.sendWindow.getAndAdd(delta);
    }

    @Override
    public int updateRecvWindow(int delta) {
        return this.recvWindow.getAndAdd(delta);
    }

    @Override
    public void close() {
        CloseState oldState = this.closeState.getAndSet(CloseState.CLOSED);
        if (oldState != CloseState.CLOSED) {
            int deltaClosing = oldState == CloseState.CLOSING ? -1 : 0;
            this.updateStreamCount(-1, deltaClosing);
            this.onClose();
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        this.notifyClosed(this);
    }

    private void updateStreamCount(int deltaStream, int deltaClosing) {
        ((HTTP2Session)this.session).updateStreamCount(this.isLocal(), deltaStream, deltaClosing);
    }

    @Override
    public void succeeded() {
        Callback callback = this.endWrite();
        if (callback != null) {
            callback.succeeded();
        }
    }

    @Override
    public void failed(Throwable x) {
        Callback callback = this.endWrite();
        if (callback != null) {
            callback.failed(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invocable.InvocationType getInvocationType() {
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            return this.sendCallback != null ? this.sendCallback.getInvocationType() : Callback.super.getInvocationType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callback endWrite() {
        HTTP2Stream hTTP2Stream = this;
        synchronized (hTTP2Stream) {
            Callback callback = this.sendCallback;
            this.sendCallback = null;
            return callback;
        }
    }

    private void notifyNewStream(Stream stream) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onNewStream(stream);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener {}", listener, x);
            }
        }
    }

    private void notifyData(Stream stream, DataFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onData(stream, frame, callback);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener " + listener, x);
                callback.failed(x);
            }
        } else {
            callback.succeeded();
        }
    }

    private void notifyReset(Stream stream, ResetFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onReset(stream, frame, callback);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener " + listener, x);
                callback.failed(x);
            }
        } else {
            callback.succeeded();
        }
    }

    private boolean notifyIdleTimeout(Stream stream, Throwable failure) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return true;
        }
        try {
            return listener.onIdleTimeout(stream, failure);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
            return true;
        }
    }

    private void notifyFailure(Stream stream, FailureFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onFailure(stream, frame.getError(), frame.getReason(), frame.getFailure(), callback);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener " + listener, x);
                callback.failed(x);
            }
        } else {
            callback.succeeded();
        }
    }

    private void notifyClosed(Stream stream) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onClosed(stream);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
        }
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        out.append(this.toString()).append(System.lineSeparator());
    }

    public String toString() {
        return String.format("%s@%x#%d@%x{sendWindow=%s,recvWindow=%s,reset=%b/%b,%s,age=%d,attachment=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getId(), this.session.hashCode(), this.sendWindow, this.recvWindow, this.localReset, this.remoteReset, this.closeState, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.timeStamp), this.attachment);
    }
}

