/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Function;

public class BaseConverters
implements Converter {
    public Object convert(Class<?> desiredType, final Object in) throws Exception {
        if (desiredType == Class.class) {
            try {
                return Class.forName(in.toString());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (desiredType.isAssignableFrom(String.class) && in instanceof InputStream) {
            return this.read((InputStream)in);
        }
        if (in instanceof Function && BaseConverters.isFunctional(desiredType)) {
            return Proxy.newProxyInstance(desiredType.getClassLoader(), new Class[]{desiredType}, new InvocationHandler(){
                Function command;
                {
                    this.command = (Function)in;
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (BaseConverters.isObjectMethod(method)) {
                        return method.invoke((Object)this.command, args);
                    }
                    if (method.isDefault()) {
                        Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                        field.setAccessible(true);
                        MethodHandles.Lookup lookup = (MethodHandles.Lookup)field.get(null);
                        return lookup.unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
                    }
                    return this.command.execute(null, args != null ? Arrays.asList(args) : Collections.emptyList());
                }
            });
        }
        return null;
    }

    public CharSequence format(Object target, int level, Converter converter) throws IOException {
        if (level == 0 && target instanceof InputStream) {
            return this.read((InputStream)target);
        }
        return null;
    }

    private CharSequence read(InputStream in) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = in.read()) > 0) {
            if (c >= 32 && c <= 127 || c == 10 || c == 13) {
                sb.append((char)c);
                continue;
            }
            String s = Integer.toHexString(c).toUpperCase();
            sb.append("\\");
            if (s.length() < 1) {
                sb.append(0);
            }
            sb.append(s);
        }
        return sb;
    }

    public static boolean isFunctional(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        int nb = 0;
        for (Method method : clazz.getMethods()) {
            if (method.isDefault() || BaseConverters.isObjectMethod(method) || BaseConverters.isStatic(method)) continue;
            ++nb;
        }
        return nb == 1;
    }

    public static boolean isStatic(Method method) {
        return (method.getModifiers() & 8) == 8;
    }

    public static boolean isObjectMethod(Method method) {
        switch (method.getName()) {
            case "toString": {
                if (method.getParameterCount() != 0 || method.getReturnType() != String.class) break;
                return true;
            }
            case "equals": {
                if (method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class || method.getReturnType() != Boolean.TYPE) break;
                return true;
            }
            case "hashCode": {
                if (method.getParameterCount() != 0 || method.getReturnType() != Integer.TYPE) break;
                return true;
            }
        }
        return false;
    }
}

