/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.util;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.felix.framework.util.SecureAction;

public final class TrustManager {
    private final SecureAction m_action;
    private final String m_crlList;
    private final String m_typeList;
    private final String m_passwdList;
    private final String m_storeList;
    private Collection m_caCerts = null;
    private Collection m_crls = null;

    public TrustManager(String crlList, String typeList, String passwdList, String storeList, SecureAction action) {
        this.m_crlList = crlList;
        this.m_typeList = typeList;
        this.m_passwdList = passwdList;
        this.m_storeList = storeList;
        this.m_action = action;
    }

    private synchronized void init() {
        if (this.m_caCerts == null) {
            try {
                this.initCRLs();
                this.initCaCerts();
            }
            catch (Exception ex) {
                this.m_caCerts = new ArrayList();
                this.m_crls = new ArrayList();
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCRLs() throws Exception {
        ArrayList<? extends CRL> result = new ArrayList<CRL>();
        if (this.m_crlList.trim().length() != 0) {
            CertificateFactory fac = CertificateFactory.getInstance("X509");
            StringTokenizer tok = new StringTokenizer(this.m_crlList, "|");
            while (tok.hasMoreElements()) {
                InputStream input = null;
                try {
                    input = this.m_action.getURLConnectionInputStream(this.m_action.createURL(null, tok.nextToken(), null).openConnection());
                    result.addAll(fac.generateCRLs(input));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        this.m_crls = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCaCerts() throws Exception {
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        if (this.m_storeList.trim().length() != 0) {
            StringTokenizer storeTok = new StringTokenizer(this.m_storeList, "|");
            StringTokenizer passwdTok = new StringTokenizer(this.m_passwdList, "|");
            StringTokenizer typeTok = new StringTokenizer(this.m_typeList, "|");
            while (storeTok.hasMoreTokens()) {
                KeyStore ks = KeyStore.getInstance(typeTok.nextToken().trim());
                InputStream input = null;
                try {
                    input = this.m_action.getURLConnectionInputStream(this.m_action.createURL(null, storeTok.nextToken().trim(), null).openConnection());
                    String pass = passwdTok.nextToken().trim();
                    ks.load(input, pass.length() > 0 ? pass.toCharArray() : null);
                    Enumeration<String> e = ks.aliases();
                    while (e.hasMoreElements()) {
                        String alias = e.nextElement();
                        result.add(ks.getCertificate(alias));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        this.m_caCerts = result;
    }

    public Collection getCRLs() {
        this.init();
        return this.m_crls;
    }

    public Collection getCaCerts() {
        this.init();
        return this.m_caCerts;
    }
}

