/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.felix.connect.Revision;

class URLRevision
implements Revision {
    private final URL m_url;
    private final long m_lastModified;
    private WeakReference<byte[]> m_urlContent;

    public URLRevision(URL url, long lastModified) {
        this.m_url = url;
        this.m_lastModified = lastModified > 0L ? lastModified : System.currentTimeMillis();
    }

    @Override
    public long getLastModified() {
        return this.m_lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<String> getEntries() {
        InputStream content = null;
        JarInputStream jarInput = null;
        try {
            JarEntry jarEntry;
            content = this.getUrlContent();
            jarInput = new JarInputStream(content);
            ArrayList<String> entries = new ArrayList<String>();
            while ((jarEntry = jarInput.getNextJarEntry()) != null) {
                entries.add(jarEntry.getName());
            }
            Enumeration<String> enumeration = Collections.enumeration(entries);
            return enumeration;
        }
        catch (IOException e) {
            e.printStackTrace();
            Enumeration<String> enumeration = Collections.enumeration(Collections.EMPTY_LIST);
            return enumeration;
        }
        finally {
            this.close(content);
            this.close(jarInput);
        }
    }

    @Override
    public URL getEntry(String entryName) {
        try {
            return new URL(this.m_url, entryName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized InputStream getUrlContent() throws IOException {
        BufferedInputStream in = null;
        ByteArrayOutputStream out = null;
        byte[] content = null;
        try {
            if (this.m_urlContent == null || (content = (byte[])this.m_urlContent.get()) == null) {
                int c;
                out = new ByteArrayOutputStream(4096);
                in = new BufferedInputStream(this.m_url.openStream(), 4096);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                content = out.toByteArray();
                this.m_urlContent = new WeakReference<byte[]>(content);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
            this.close(out);
            this.close(in);
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            this.close(out);
            this.close(in);
            throw throwable;
        }
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

