/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.substrate.impl.json;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.felix.atomos.utils.substrate.api.dynproxy.DynamicProxyConfiguration;

public class DynamicProxyJsonUtil {
    private static String COMMA = ",";
    private static String END = "]";
    private static String ITEM_PATTERN_EXIST = "\"%s\"";
    private static char NL = (char)10;
    private static String START = "[";

    private static Object ind(int num) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            indent.append("  ");
        }
        return indent.toString();
    }

    public static String json(DynamicProxyConfiguration dynamicProxyConfig) {
        AtomicBoolean firstSet = new AtomicBoolean();
        AtomicBoolean firstItem = new AtomicBoolean();
        StringBuilder json = new StringBuilder();
        json.append(START);
        for (Set items : dynamicProxyConfig.getItems()) {
            if (!firstSet.compareAndSet(false, true)) {
                json.append(COMMA);
            }
            json.append(NL);
            json.append(DynamicProxyJsonUtil.ind(1));
            json.append(START);
            for (String item : items.stream().sorted().collect(Collectors.toSet())) {
                if (!firstItem.compareAndSet(false, true)) {
                    json.append(COMMA);
                }
                json.append(String.format(ITEM_PATTERN_EXIST, item));
            }
            firstItem.set(false);
            json.append(END);
        }
        json.append(NL);
        json.append(END);
        return json.toString();
    }
}

