/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core.plugins.index;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.FileType;
import org.apache.felix.atomos.utils.api.IndexInfo;
import org.apache.felix.atomos.utils.api.plugin.JarPlugin;
import org.apache.felix.atomos.utils.core.IndexInfoImpl;
import org.apache.felix.atomos.utils.core.plugins.index.IndexOutputType;
import org.apache.felix.atomos.utils.core.plugins.index.IndexPluginConfig;
import org.apache.felix.atomos.utils.substrate.api.resource.ResourceConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultResourceConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.json.ResourceJsonUtil;

public class IndexPlugin
implements JarPlugin<IndexPluginConfig> {
    private static final String ATOMOS_BUNDLE_SEPARATOR = "ATOMOS_BUNDLE";
    public static final String ATOMOS_BUNDLES_BASE_PATH = "atomos/";
    public static final String ATOMOS_INDEX_FILE_NAME = "bundles.index";
    public static final String ATOMOS_BUNDLES_INDEX = "atomos/bundles.index";
    public static final String ATOMOS_CATH_ALL = "atomos/.*$";
    private static final String ATOMOS_SUBSTRATE_JAR = "atomos.substrate.jar";
    private AtomicLong counter = new AtomicLong();
    JarOutputStream jos;
    private ArrayList<IndexInfo> indexInfos;
    private Map<String, Boolean> uniquePaths;
    private Path substrateJar;
    private IndexPluginConfig config;

    private static boolean include(JarEntry entry) {
        String path = entry.getName();
        return !entry.isDirectory() && !IndexPlugin.isClass(path);
    }

    private static boolean isClass(String path) {
        return path.endsWith(".class");
    }

    public void initJar(JarFile jar, Context context, URLClassLoader classLoader) {
        jar.stream().filter(IndexPlugin::include).forEach(e -> this.uniquePaths.compute(e.getName(), (p, b) -> "META-INF/MANIFEST.MF".equals(p) || p.indexOf(47) < 0 || b != null ? Boolean.FALSE : Boolean.TRUE));
    }

    public void doJar(JarFile jar, Context context, URLClassLoader classLoader) {
        long id = this.counter.getAndIncrement();
        IndexInfoImpl info = new IndexInfoImpl();
        try {
            Attributes attributes;
            Manifest mf = jar.getManifest();
            Attributes attributes2 = attributes = mf == null ? null : mf.getMainAttributes();
            if (attributes != null) {
                info.setBsn(attributes.getValue("Bundle-SymbolicName"));
                info.setVersion(attributes.getValue("Bundle-Version"));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        info.setId(Long.toString(id));
        if (info.getBundleSymbolicName() == null) {
            return;
        }
        if (info.getVersion() == null) {
            info.setVersion("0.0");
        }
        List<String> files = jar.stream().peek(j -> {
            try {
                if (Boolean.FALSE == this.uniquePaths.get(j.getName())) {
                    String fileName = ATOMOS_BUNDLES_BASE_PATH + id + "/" + j.getName();
                    if (this.isJarType()) {
                        JarEntry entry = new JarEntry(fileName);
                        if (j.getCreationTime() != null) {
                            entry.setCreationTime(j.getCreationTime());
                        }
                        if (j.getComment() != null) {
                            entry.setComment(j.getComment());
                        }
                        this.jos.putNextEntry(entry);
                        this.jos.write(jar.getInputStream((ZipEntry)j).readAllBytes());
                    } else {
                        Path path = this.config.indexOutputDirectory().resolve(fileName);
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        Files.write(path, jar.getInputStream((ZipEntry)j).readAllBytes(), new OpenOption[0]);
                        BasicFileAttributeView attrs = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
                        FileTime time = j.getCreationTime();
                        attrs.setTimes(time, time, time);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).map(ZipEntry::getName).collect(Collectors.toList());
        info.setFiles(files);
        this.indexInfos.add(info);
    }

    public void init(IndexPluginConfig config) {
        this.config = config;
    }

    private boolean isJarType() {
        return IndexOutputType.JAR.equals((Object)this.config.indexOutputType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postJars(Context context) {
        try {
            ByteArrayOutputStream indexBytes;
            ArrayList bundleIndexLines = new ArrayList();
            LinkedHashSet<String> resources = new LinkedHashSet<String>();
            this.indexInfos.stream().filter(i -> i.getBundleSymbolicName() != null).sorted((i1, i2) -> i1.getBundleSymbolicName().compareTo(i2.getBundleSymbolicName())).forEach(i -> {
                bundleIndexLines.add(ATOMOS_BUNDLE_SEPARATOR);
                bundleIndexLines.add(i.getId());
                bundleIndexLines.add(i.getBundleSymbolicName());
                bundleIndexLines.add(i.getVersion());
                i.getFiles().forEach(f -> {
                    bundleIndexLines.add(f);
                    if (!IndexPlugin.isClass(f)) {
                        if (Boolean.FALSE == this.uniquePaths.get(f)) {
                            resources.add(ATOMOS_BUNDLES_BASE_PATH + i.getId() + "/" + f);
                        }
                        if (!f.endsWith("/") && !"META-INF/MANIFEST.MF".equals(f)) {
                            resources.add((String)f);
                        }
                    }
                });
            });
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));){
                indexBytes = out;
                bundleIndexLines.forEach(l -> {
                    try {
                        writer.append((CharSequence)l).append('\n');
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
            }
            this.writeIndexFile(indexBytes.toByteArray(), context);
            if (this.isJarType()) {
                this.writeGraalResourceConfig(resources, context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.jos != null) {
                try {
                    this.jos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.isJarType()) {
            context.addFile(this.substrateJar, FileType.INDEX_JAR);
        } else {
            context.addFile(this.config.indexOutputDirectory(), FileType.INDEX_DIR);
        }
    }

    public void preJars(Context context) {
        Path indexOutputDirectory = this.config.indexOutputDirectory();
        if (!indexOutputDirectory.toFile().isDirectory()) {
            throw new IllegalArgumentException("Output file must be a directory." + indexOutputDirectory);
        }
        if (!indexOutputDirectory.toFile().exists()) {
            try {
                Files.createDirectories(indexOutputDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.isJarType()) {
            this.substrateJar = indexOutputDirectory.resolve(ATOMOS_SUBSTRATE_JAR);
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            try {
                this.jos = new JarOutputStream((OutputStream)new FileOutputStream(this.substrateJar.toFile()), manifest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.counter = new AtomicLong(0L);
        this.indexInfos = new ArrayList();
        this.uniquePaths = new HashMap<String, Boolean>();
    }

    private void writeGraalResourceConfig(Collection<String> resources, Context context) throws IOException {
        resources.add(ATOMOS_CATH_ALL);
        DefaultResourceConfiguration rci = new DefaultResourceConfiguration();
        rci.addResourcePattern(resources);
        context.addResourceConfig((ResourceConfiguration)rci);
        String graalResConfJson = ResourceJsonUtil.json((ResourceConfiguration)rci);
        JarEntry graalResConfEntry = new JarEntry("META-INF/native-image/resource-config.json");
        this.jos.putNextEntry(graalResConfEntry);
        this.jos.write(graalResConfJson.getBytes());
        this.jos.flush();
    }

    private void writeIndexFile(byte[] bytes, Context context) throws IOException {
        if (this.isJarType()) {
            JarEntry atomosIndexEntry = new JarEntry(ATOMOS_BUNDLES_INDEX);
            this.jos.putNextEntry(atomosIndexEntry);
            this.jos.write(bytes);
        } else {
            Files.write(this.config.indexOutputDirectory().resolve(ATOMOS_BUNDLES_INDEX), bytes, new OpenOption[0]);
        }
        DefaultResourceConfiguration resourceConfig = new DefaultResourceConfiguration();
        resourceConfig.addResourcePattern(ATOMOS_BUNDLES_INDEX);
        context.addResourceConfig((ResourceConfiguration)resourceConfig);
    }
}

