/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.osgi;

import org.apache.felix.gogo.runtime.osgi.OSGiCommands;
import org.apache.felix.gogo.runtime.osgi.ServiceCommand;
import org.apache.felix.gogo.runtime.shell.CommandShellImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.command.Converter;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.threadio.ThreadIO;

public class OSGiShell
extends CommandShellImpl {
    Bundle bundle;
    OSGiCommands commands;

    public void start() throws Exception {
        this.commands = new OSGiCommands(this.bundle);
        this.addCommand("osgi", this.bundle);
        this.addCommand("osgi", this.commands);
        this.setConverter(this.commands);
        if (this.bundle.getState() == 32 || this.bundle.getState() == 8) {
            this.addCommand("osgi", this.commands.service(PackageAdmin.class.getName(), null), PackageAdmin.class);
            this.addCommand("osgi", (Object)this.commands.getContext(), BundleContext.class);
            try {
                String sl = "org.osgi.service.startlevel.StartLevel";
                Class slClass = this.bundle.loadClass(sl);
                this.addCommand("osgi", this.commands.service(sl, null), slClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                String pa = "org.osgi.service.permissionadmin.PermissionAdmin";
                Class paClass = this.bundle.loadClass(pa);
                this.addCommand("osgi", this.commands.service(pa, null), paClass);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            System.err.println("eek! bundle not active: " + this.bundle);
        }
    }

    public Object get(String name) {
        if (this.bundle.getBundleContext() != null) {
            BundleContext context = this.bundle.getBundleContext();
            try {
                Object cmd = super.get(name);
                if (cmd != null) {
                    return cmd;
                }
                int n = name.indexOf(58);
                if (n < 0) {
                    return null;
                }
                String service = name.substring(0, n);
                String function = name.substring(n + 1);
                if (service.length() == 0 || function.length() == 0) {
                    return null;
                }
                String filter = String.format("(&(osgi.command.scope=%s)(osgi.command.function=%s))", service, function);
                ServiceReference[] refs = context.getServiceReferences(null, filter);
                if (refs == null || refs.length == 0) {
                    return null;
                }
                if (refs.length > 1) {
                    throw new IllegalArgumentException("Command name is not unambiguous: " + name + ", found multiple impls");
                }
                return new ServiceCommand(this, refs[0], function);
            }
            catch (InvalidSyntaxException ise) {
                ise.printStackTrace();
            }
        }
        return super.get(name);
    }

    public void setThreadio(Object t) {
        super.setThreadio((ThreadIO)t);
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setConverter(Converter c) {
        super.setConverter(c);
    }
}

