/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.config;

import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="list", description="Lists existing configurations.")
public class ListCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="query", description="Specify a LDAP query", required=false, multiValued=false)
    String query;

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Configuration[] configs;
        for (Configuration config : configs = admin.listConfigurations(this.query)) {
            System.out.println("----------------------------------------------------------------");
            System.out.println("Pid:            " + config.getPid());
            if (config.getFactoryPid() != null) {
                System.out.println("FactoryPid:     " + config.getFactoryPid());
            }
            System.out.println("BundleLocation: " + config.getBundleLocation());
            if (config.getProperties() == null) continue;
            System.out.println("Properties:");
            Dictionary props = config.getProperties();
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                System.out.println("   " + key + " = " + props.get(key));
            }
        }
    }
}

