/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.ArrayList;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.codec.UserData;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;

public class GroupData
extends UserData {
    private String[] members;
    private String[] requiredMembers;

    public GroupData(Group group) {
        super(group.getName(), 2);
        this.setRequiredMembers(group);
        this.setMembers(group);
    }

    public GroupData(String name, String[] members, String[] requiredMembers) {
        super(name, 2);
        this.members = members;
        this.requiredMembers = requiredMembers;
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Name", this.name);
            items.put("Type", this.type);
            items.put("Members", this.members);
            items.put("RequiredMembers", this.requiredMembers);
            return new CompositeDataSupport(UserAdminMBean.GROUP_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    public static GroupData from(CompositeData data) {
        if (data == null) {
            return null;
        }
        String name = (String)data.get("Name");
        String[] members = (String[])data.get("Members");
        String[] requiredMembers = (String[])data.get("RequiredMembers");
        return new GroupData(name, members, requiredMembers);
    }

    public String[] getMembers() {
        return this.members;
    }

    public String[] getRequiredMembers() {
        return this.requiredMembers;
    }

    private void setMembers(Group group) {
        Role[] roles = group.getMembers();
        if (roles != null) {
            ArrayList<String> members = new ArrayList<String>();
            for (Role role : roles) {
                members.add(role.getName());
            }
            this.members = members.toArray(new String[roles.length]);
        }
    }

    private void setRequiredMembers(Group group) {
        Role[] requiredRoles = group.getRequiredMembers();
        if (requiredRoles != null) {
            ArrayList<String> reqMembers = new ArrayList<String>();
            for (Role role : requiredRoles) {
                reqMembers.add(role.getName());
            }
            this.requiredMembers = reqMembers.toArray(new String[requiredRoles.length]);
        }
    }
}

