/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.console.BlueprintContainerAware;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="ssh", name="ssh", description="Connects to a remote SSH server")
public class SshAction
extends OsgiCommandSupport
implements BlueprintContainerAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Option(name="-l", aliases={"--username"}, description="The user name for remote login", required=false, multiValued=false)
    private String username;
    @Option(name="-P", aliases={"--password"}, description="The password for remote login", required=false, multiValued=false)
    private String password;
    @Argument(index=0, name="hostname", description="The host name to connect to via SSH", required=true, multiValued=false)
    private String hostname;
    @Option(name="-p", aliases={"--port"}, description="The port to use for SSH connection", required=false, multiValued=false)
    private int port = 22;
    private BlueprintContainer container;
    private ClientSession session;
    private String sshClientId;

    public void setBlueprintContainer(BlueprintContainer container) {
        assert (container != null);
        this.container = container;
    }

    public void setSshClientId(String sshClientId) {
        this.sshClientId = sshClientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        System.out.println("Connecting to host " + this.hostname + " on port " + this.port);
        if (this.username == null || this.password == null) {
            this.log.debug("Prompting user for credentials");
            if (this.username == null) {
                this.username = this.readLine("Login: ");
            }
            if (this.password == null) {
                this.password = this.readLine("Password: ");
            }
        }
        SshClient client = (SshClient)this.container.getComponentInstance(this.sshClientId);
        this.log.debug("Created client: {}", (Object)client);
        client.start();
        try {
            ConnectFuture future = client.connect(this.hostname, this.port);
            future.await();
            this.session = future.getSession();
            try {
                System.out.println("Connected");
                this.session.authPassword(this.username, this.password);
                int ret = this.session.waitFor(14, 0L);
                if ((ret & 8) == 0) {
                    System.err.println("Authentication failed");
                    Object var4_4 = null;
                    return var4_4;
                }
                ClientChannel channel = this.session.createChannel("shell");
                channel.setIn((InputStream)new NoCloseInputStream(System.in));
                ((ChannelShell)channel).setupSensibleDefaultPty();
                channel.setOut((OutputStream)new NoCloseOutputStream((OutputStream)System.out));
                channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)System.err));
                channel.open();
                channel.waitFor(2, 0L);
            }
            finally {
                this.session.close(false);
            }
        }
        finally {
            client.stop();
        }
        return null;
    }

    public String readLine(String msg) throws IOException {
        StringBuffer sb = new StringBuffer();
        System.err.print(msg);
        System.err.flush();
        while (true) {
            int c;
            if ((c = ((OsgiCommandSupport)this).session.getKeyboard().read()) < 0) {
                return null;
            }
            System.err.print((char)c);
            if (c == 13 || c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }
}

