/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IReferralHandler;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateAdapter;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.dialogs.SelectReferralConnectionDialog;
import org.eclipse.ui.PlatformUI;

public class ConnectionUIReferralHandler
extends ConnectionUpdateAdapter
implements IReferralHandler {
    private Map<String, Connection> referralUrlToReferralConnectionCache = new ConcurrentHashMap<String, Connection>();

    public ConnectionUIReferralHandler() {
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionCorePlugin.getDefault().getEventRunner());
    }

    public void connectionClosed(Connection connection) {
        this.referralUrlToReferralConnectionCache.clear();
    }

    public Connection getReferralConnection(List<String> referralUrls) {
        Connection[] referralConnections = new Connection[1];
        try {
            String normalizedUrl;
            for (String url : referralUrls) {
                Connection[] connections;
                normalizedUrl = Utils.getSimpleNormalizedUrl((LdapUrl)new LdapUrl(url));
                if (!this.referralUrlToReferralConnectionCache.containsKey(normalizedUrl)) continue;
                Connection referralConnection = this.referralUrlToReferralConnectionCache.get(normalizedUrl);
                Connection[] connectionArray = connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
                int n = connections.length;
                int n2 = 0;
                while (n2 < n) {
                    Connection connection = connectionArray[n2];
                    if (connection.equals(referralConnection)) {
                        return referralConnection;
                    }
                    ++n2;
                }
                this.referralUrlToReferralConnectionCache.remove(normalizedUrl);
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                SelectReferralConnectionDialog dialog = new SelectReferralConnectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), referralUrls);
                if (dialog.open() == 0) {
                    Connection connection;
                    connectionArray[0] = connection = dialog.getReferralConnection();
                }
            });
            if (referralConnections[0] != null) {
                for (String url : referralUrls) {
                    normalizedUrl = Utils.getSimpleNormalizedUrl((LdapUrl)new LdapUrl(url));
                    this.referralUrlToReferralConnectionCache.put(normalizedUrl, referralConnections[0]);
                }
            }
        }
        catch (LdapURLEncodingException ldapURLEncodingException) {}
        return referralConnections[0];
    }
}

