/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import org.apache.directory.server.config.beans.JdbmPartitionBean;
import org.apache.directory.studio.apacheds.configuration.editor.AbstractPartitionSpecificDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionDetailsPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JdbmPartitionSpecificDetailsBlock
extends AbstractPartitionSpecificDetailsBlock<JdbmPartitionBean> {
    private Text cacheSizeText;
    private Button enableOptimizerCheckbox;

    public JdbmPartitionSpecificDetailsBlock(PartitionDetailsPage detailsPage, JdbmPartitionBean partition) {
        super(detailsPage, partition);
    }

    @Override
    public Composite createBlockContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(composite, Messages.getString("PartitionDetailsPage.CacheSize"));
        this.cacheSizeText = toolkit.createText(composite, "");
        this.cacheSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.cacheSizeText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.enableOptimizerCheckbox = toolkit.createButton(composite, Messages.getString("PartitionDetailsPage.EnableOptimzer"), 32);
        this.enableOptimizerCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        return composite;
    }

    private void addListeners() {
        this.cacheSizeText.addModifyListener(this.dirtyModifyListener);
        this.enableOptimizerCheckbox.addSelectionListener(this.dirtySelectionListener);
    }

    private void removeListeners() {
        this.cacheSizeText.removeModifyListener(this.dirtyModifyListener);
        this.enableOptimizerCheckbox.removeSelectionListener(this.dirtySelectionListener);
    }

    @Override
    public void refresh() {
        this.removeListeners();
        if (this.partition != null) {
            this.cacheSizeText.setText("" + ((JdbmPartitionBean)this.partition).getPartitionCacheSize());
            this.enableOptimizerCheckbox.setSelection(((JdbmPartitionBean)this.partition).isJdbmPartitionOptimizerEnabled());
        }
        this.addListeners();
    }

    @Override
    public void commit(boolean onSave) {
        if (this.partition != null) {
            try {
                ((JdbmPartitionBean)this.partition).setPartitionCacheSize(Integer.parseInt(this.cacheSizeText.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
            ((JdbmPartitionBean)this.partition).setJdbmPartitionOptimizerEnabled(this.enableOptimizerCheckbox.getSelection());
        }
    }
}

