/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.servlet.CookieUtil;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTocsArray;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.IHelpWorkingSetManager;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetComparator;

public class InfocenterWorkingSetManager
implements IHelpWorkingSetManager {
    private static final String COOKIE_WSET_CONTENTS = "wset_contents";
    private static final String COOKIE_WSET_CRITERIA = "wset_criteria";
    private static final int MAX_COOKIES = 15;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String currentWorkingSet = "";
    private SortedSet<WorkingSet> workingSets = new TreeSet<WorkingSet>((Comparator<WorkingSet>)new WorkingSetComparator());
    private String locale;
    private AdaptableTocsArray root;
    private static final String UNCATEGORIZED = "Uncategorized";
    private Map<String, Set<String>> allCriteriaValues;

    public InfocenterWorkingSetManager(HttpServletRequest request, HttpServletResponse response, String locale) {
        this.request = request;
        this.response = response;
        this.locale = locale;
        this.restoreState();
    }

    public AdaptableTocsArray getRoot() {
        if (this.root == null) {
            this.root = new AdaptableTocsArray((IToc[])HelpPlugin.getTocManager().getTocs(this.locale));
        }
        return this.root;
    }

    public void addWorkingSet(WorkingSet workingSet) throws IOException {
        if (workingSet == null || this.workingSets.contains(workingSet)) {
            return;
        }
        this.workingSets.add(workingSet);
        this.saveState();
    }

    public WorkingSet createWorkingSet(String name, AdaptableHelpResource[] elements) {
        return new WorkingSet(name, elements);
    }

    public WorkingSet createWorkingSet(String name, AdaptableHelpResource[] elements, CriterionResource[] criteria) {
        return new WorkingSet(name, elements, criteria);
    }

    public WorkingSet getWorkingSet(String name) {
        if (name == null || this.workingSets == null) {
            return null;
        }
        for (WorkingSet workingSet : this.workingSets) {
            if (!name.equals(workingSet.getName())) continue;
            return workingSet;
        }
        return null;
    }

    public WorkingSet[] getWorkingSets() {
        return this.workingSets.toArray(new WorkingSet[this.workingSets.size()]);
    }

    public void removeWorkingSet(WorkingSet workingSet) {
        this.workingSets.remove(workingSet);
        try {
            this.saveState();
        }
        catch (IOException iOException) {}
    }

    private void restoreState() {
        this.restoreContents();
        this.restoreCriteria();
    }

    private void restoreContents() {
        String data = CookieUtil.restoreString(COOKIE_WSET_CONTENTS, this.request);
        if (data == null) {
            return;
        }
        String[] values = data.split("\\|", -1);
        if (values.length < 1) {
            return;
        }
        this.currentWorkingSet = URLCoder.decode((String)values[0]);
        int i = 1;
        while (i < values.length) {
            block9: {
                String[] nameAndHrefs = values[i].split("&", -1);
                String name = URLCoder.decode((String)nameAndHrefs[0]);
                AdaptableHelpResource[] elements = new AdaptableHelpResource[nameAndHrefs.length - 1];
                String previousToc = "";
                int e = 0;
                while (e < nameAndHrefs.length - 1) {
                    int h = e + 1;
                    String decodedName = URLCoder.decode((String)nameAndHrefs[h]);
                    elements[e] = this.getAdaptableToc(decodedName);
                    if (elements[e] == null) {
                        int suffixStart = decodedName.lastIndexOf(95, decodedName.length() - 2);
                        if (suffixStart > 0) {
                            previousToc = decodedName.substring(0, suffixStart);
                        } else if (suffixStart == 0) {
                            decodedName = String.valueOf(previousToc) + decodedName;
                        }
                        elements[e] = this.getAdaptableTopic(decodedName);
                    }
                    if (elements[e] != null) {
                        ++e;
                        continue;
                    }
                    break block9;
                }
                WorkingSet ws = this.createWorkingSet(name, elements, null);
                this.workingSets.add(ws);
            }
            ++i;
        }
    }

    private void restoreCriteria() {
        String data = CookieUtil.restoreString(COOKIE_WSET_CRITERIA, this.request);
        if (data == null) {
            return;
        }
        String[] values = data.split("\\|", -1);
        if (values.length < 1) {
            return;
        }
        int i = 1;
        while (i < values.length) {
            String[] nameAndCriteria = values[i].split("\\$", -1);
            if (nameAndCriteria.length >= 2) {
                String name = URLCoder.decode((String)nameAndCriteria[0]);
                ArrayList<CriterionResource> criteriaResource = new ArrayList<CriterionResource>();
                int j = 1;
                while (j < nameAndCriteria.length) {
                    String criterion = nameAndCriteria[j];
                    String[] keyAndValue = criterion.split("#", -1);
                    if (keyAndValue.length == 2) {
                        String key = URLCoder.decode((String)keyAndValue[0]);
                        String value = URLCoder.decode((String)keyAndValue[1]);
                        String[] criterionValues = value.split(",", -1);
                        if (criterionValues.length >= 1) {
                            List<String> criterionValuesList = Arrays.asList(criterionValues);
                            CriterionResource criterionResource = new CriterionResource(key, criterionValuesList);
                            criteriaResource.add(criterionResource);
                        }
                    }
                    ++j;
                }
                WorkingSet workingset = this.getWorkingSet(name);
                if (workingset != null) {
                    CriterionResource[] criteria = new CriterionResource[criteriaResource.size()];
                    criteriaResource.toArray(criteria);
                    workingset.setCriteria(criteria);
                }
            }
            ++i;
        }
    }

    private void saveState() throws IOException {
        this.saveContents();
        this.saveCriteria();
    }

    private void saveContents() throws IOException {
        StringBuilder data = new StringBuilder();
        data.append(URLCoder.compactEncode((String)this.currentWorkingSet));
        for (WorkingSet ws : this.workingSets) {
            data.append('|');
            data.append(URLCoder.compactEncode((String)ws.getName()));
            AdaptableHelpResource[] resources = ws.getElements();
            AdaptableToc lastTopicParent = null;
            AdaptableHelpResource[] adaptableHelpResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                AdaptableHelpResource resource = adaptableHelpResourceArray[n2];
                IAdaptable parent = resource.getParent();
                if (parent == this.getRoot()) {
                    data.append('&');
                    data.append(URLCoder.compactEncode((String)resource.getHref()));
                    lastTopicParent = null;
                } else {
                    AdaptableToc toc = (AdaptableToc)parent;
                    AdaptableHelpResource[] siblings = toc.getChildren();
                    int t = 0;
                    while (t < siblings.length) {
                        if (siblings[t] == resource) {
                            data.append('&');
                            if (!toc.equals(lastTopicParent)) {
                                data.append(URLCoder.compactEncode((String)toc.getHref()));
                            }
                            data.append('_');
                            data.append(t);
                            data.append('_');
                            lastTopicParent = toc;
                            break;
                        }
                        ++t;
                    }
                }
                ++n2;
            }
        }
        this.saveToCookie(COOKIE_WSET_CONTENTS, data.toString());
    }

    private void saveCriteria() throws IOException {
        StringBuilder data = new StringBuilder();
        data.append(URLCoder.compactEncode((String)this.currentWorkingSet));
        for (WorkingSet ws : this.workingSets) {
            CriterionResource[] criteria;
            data.append('|');
            data.append(URLCoder.compactEncode((String)ws.getName()));
            CriterionResource[] criterionResourceArray = criteria = ws.getCriteria();
            int n = criteria.length;
            int n2 = 0;
            while (n2 < n) {
                CriterionResource criterion = criterionResourceArray[n2];
                String criterionName = criterion.getCriterionName();
                List criterionValues = criterion.getCriterionValues();
                if (criterionValues != null && !criterionValues.isEmpty()) {
                    data.append('$');
                    data.append(URLCoder.compactEncode((String)criterionName));
                    data.append('#');
                    for (String value : criterionValues) {
                        data.append(URLCoder.compactEncode((String)(String.valueOf(value) + ',')));
                    }
                }
                ++n2;
            }
        }
        this.saveToCookie(COOKIE_WSET_CRITERIA, data.toString());
    }

    private void saveToCookie(String name, String data) throws IOException {
        try {
            CookieUtil.saveString(name, data, 15, this.request, this.response);
        }
        catch (IOException ioe) {
            if (HelpWebappPlugin.DEBUG_WORKINGSETS) {
                String msg = "InfocenterWorkingSetManager.saveState(): Too much data to save: " + data;
                System.out.println(msg);
            }
            throw ioe;
        }
    }

    public void workingSetChanged(WorkingSet changedWorkingSet) throws IOException {
        this.saveState();
    }

    public AdaptableToc getAdaptableToc(String href) {
        return this.getRoot().getAdaptableToc(href);
    }

    public AdaptableTopic getAdaptableTopic(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        int len = id.length();
        if (id.charAt(len - 1) == '_') {
            String indexStr = id.substring(id.lastIndexOf(95, len - 2) + 1, len - 1);
            int index = 0;
            try {
                index = Integer.parseInt(indexStr);
            }
            catch (Exception exception) {}
            String tocStr = id.substring(0, id.lastIndexOf(95, len - 2));
            AdaptableToc toc = this.getAdaptableToc(tocStr);
            if (toc == null) {
                return null;
            }
            AdaptableHelpResource[] topics = toc.getChildren();
            if (index < 0 || index >= topics.length) {
                return null;
            }
            return (AdaptableTopic)topics[index];
        }
        return null;
    }

    public String getCurrentWorkingSet() {
        return this.currentWorkingSet;
    }

    public void setCurrentWorkingSet(String workingSet) {
        this.currentWorkingSet = workingSet;
        try {
            this.saveState();
        }
        catch (IOException iOException) {}
    }

    public boolean isCriteriaScopeEnabled() {
        if (this.allCriteriaValues == null) {
            this.allCriteriaValues = HelpPlugin.getCriteriaManager().getAllCriteriaValues(this.locale);
        }
        return HelpPlugin.getCriteriaManager().isCriteriaEnabled() && !this.allCriteriaValues.isEmpty();
    }

    public String[] getCriterionIds() {
        if (this.allCriteriaValues == null) {
            this.allCriteriaValues = HelpPlugin.getCriteriaManager().getAllCriteriaValues(this.locale);
        }
        ArrayList<String> criterionIds = new ArrayList<String>();
        if (this.allCriteriaValues != null) {
            for (String criterion : this.allCriteriaValues.keySet()) {
                if (criterion == null || criterion.length() == 0 || this.getCriterionValueIds(criterion).length == 0) continue;
                criterionIds.add(criterion);
            }
            criterionIds.sort(null);
        }
        String[] ids = new String[criterionIds.size()];
        criterionIds.toArray(ids);
        return ids;
    }

    public String[] getCriterionValueIds(String criterionName) {
        Set<String> criterionValues;
        if (this.allCriteriaValues == null) {
            this.allCriteriaValues = HelpPlugin.getCriteriaManager().getAllCriteriaValues(this.locale);
        }
        ArrayList<String> valueIds = new ArrayList<String>();
        if (criterionName != null && this.allCriteriaValues != null && (criterionValues = this.allCriteriaValues.get(criterionName)) != null && !criterionValues.isEmpty()) {
            valueIds.addAll(criterionValues);
            valueIds.sort(null);
            valueIds.add(UNCATEGORIZED);
        }
        String[] valueIdsArray = new String[valueIds.size()];
        valueIds.toArray(valueIdsArray);
        return valueIdsArray;
    }

    public String getCriterionDisplayName(String criterionId) {
        return HelpPlugin.getCriteriaManager().getCriterionDisplayName(criterionId, this.locale);
    }

    public String getCriterionValueDisplayName(String criterionId, String criterionValueId) {
        return HelpPlugin.getCriteriaManager().getCriterionValueDisplayName(criterionId, criterionValueId, this.locale);
    }
}

