/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExecuteLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationApplyOnWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationFinishWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationLdifWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationModifyWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationTypeWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifeditor.editor.NonExistingLdifEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class BatchOperationWizard
extends Wizard
implements INewWizard {
    private IBrowserConnection connection;
    private BatchOperationApplyOnWizardPage applyOnPage;
    private BatchOperationTypeWizardPage typePage;
    private BatchOperationLdifWizardPage ldifPage;
    private BatchOperationModifyWizardPage modifyPage;
    private BatchOperationFinishWizardPage finishPage;

    public BatchOperationWizard() {
        super.setWindowTitle(Messages.getString("BatchOperationWizard.BatchOperation"));
        super.setNeedsProgressMonitor(true);
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_BATCH_OPERATION;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        Connection[] connections = BrowserSelectionUtils.getConnections((ISelection)selection);
        ISearch[] searches = BrowserSelectionUtils.getSearches((ISelection)selection);
        IEntry[] entries = BrowserSelectionUtils.getEntries((ISelection)selection);
        ISearchResult[] searchResults = BrowserSelectionUtils.getSearchResults((ISelection)selection);
        IBookmark[] bookmarks = BrowserSelectionUtils.getBookmarks((ISelection)selection);
        IAttribute[] attributes = BrowserSelectionUtils.getAttributes((ISelection)selection);
        IValue[] values = BrowserSelectionUtils.getValues((ISelection)selection);
        if (connections.length > 0 && connections[0].getConnectionWrapper().isConnected() || searches.length + entries.length + searchResults.length + bookmarks.length + attributes.length + values.length > 0) {
            ISearch search = BrowserSelectionUtils.getExampleSearch((ISelection)selection);
            search.setName(null);
            this.connection = search.getBrowserConnection();
            this.applyOnPage = new BatchOperationApplyOnWizardPage(BatchOperationApplyOnWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.applyOnPage);
            this.typePage = new BatchOperationTypeWizardPage(BatchOperationTypeWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.typePage);
            this.ldifPage = new BatchOperationLdifWizardPage(BatchOperationLdifWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.ldifPage);
            this.modifyPage = new BatchOperationModifyWizardPage(BatchOperationModifyWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.modifyPage);
            this.finishPage = new BatchOperationFinishWizardPage(BatchOperationFinishWizardPage.class.getName());
            this.addPage((IWizardPage)this.finishPage);
        } else {
            DummyWizardPage page = new DummyWizardPage();
            this.addPage((IWizardPage)page);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.applyOnPage.getControl(), String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_batchoperation_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.typePage.getControl(), String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_batchoperation_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.ldifPage.getControl(), String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_batchoperation_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.modifyPage.getControl(), String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_batchoperation_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.finishPage.getControl(), String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_batchoperation_wizard");
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.applyOnPage != null) {
            if (page == this.applyOnPage) {
                return this.typePage;
            }
            if (page == this.typePage && this.typePage.getOperationType() == 2) {
                return this.ldifPage;
            }
            if (page == this.typePage && this.typePage.getOperationType() == 0) {
                return this.modifyPage;
            }
            if (page == this.typePage && this.typePage.getOperationType() == 1) {
                return this.finishPage;
            }
            if (page == this.modifyPage) {
                return this.finishPage;
            }
            if (page == this.ldifPage) {
                return this.finishPage;
            }
        }
        return null;
    }

    public boolean canFinish() {
        if (this.applyOnPage != null) {
            if (!this.applyOnPage.isPageComplete()) {
                return false;
            }
            if (!this.typePage.isPageComplete()) {
                return false;
            }
            if (this.typePage.getOperationType() == 2 && !this.ldifPage.isPageComplete()) {
                return false;
            }
            if (this.typePage.getOperationType() == 0 && !this.modifyPage.isPageComplete()) {
                return false;
            }
            if (!this.finishPage.isPageComplete()) {
                return false;
            }
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        if (this.applyOnPage != null) {
            ISearch search;
            Dn[] dns;
            this.applyOnPage.saveDialogSettings();
            this.finishPage.saveDialogSettings();
            String ldifFragment = "";
            if (this.typePage.getOperationType() == 2) {
                ldifFragment = this.ldifPage.getLdifFragment();
            } else if (this.typePage.getOperationType() == 0) {
                ldifFragment = this.modifyPage.getLdifFragment();
            }
            if (this.typePage.getOperationType() == 1) {
                ldifFragment = "changetype: delete" + BrowserCoreConstants.LINE_SEPARATOR;
            }
            if ((dns = this.applyOnPage.getApplyOnDns()) == null && this.applyOnPage.getApplyOnSearch() != null && (search = this.applyOnPage.getApplyOnSearch()).getBrowserConnection() != null) {
                search.setSearchResults(null);
                SearchRunnable runnable = new SearchRunnable(new ISearch[]{search});
                IStatus status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, (IRunnableContext)this.getContainer(), (boolean)true);
                if (status.isOK()) {
                    ISearchResult[] srs = search.getSearchResults();
                    dns = new Dn[srs.length];
                    int i = 0;
                    while (i < srs.length) {
                        dns[i] = srs[i].getDn();
                        ++i;
                    }
                }
            }
            if (dns != null) {
                StringBuffer ldif = new StringBuffer();
                int i = 0;
                while (i < dns.length) {
                    ldif.append("dn: ");
                    ldif.append(dns[i].getName());
                    ldif.append(BrowserCoreConstants.LINE_SEPARATOR);
                    ldif.append(ldifFragment);
                    ldif.append(BrowserCoreConstants.LINE_SEPARATOR);
                    ++i;
                }
                if (this.finishPage.getExecutionMethod() == 1) {
                    try {
                        IDocument document;
                        NonExistingLdifEditorInput input = new NonExistingLdifEditorInput();
                        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, LdifEditor.getId());
                        IDocumentProvider documentProvider = ((LdifEditor)editor).getDocumentProvider();
                        if (documentProvider != null && (document = documentProvider.getDocument((Object)input)) != null) {
                            document.set(ldif.toString());
                        }
                    }
                    catch (PartInitException partInitException) {
                        return false;
                    }
                    return true;
                }
                if (this.finishPage.getExecutionMethod() == 2) {
                    Shell shell = Display.getDefault().getActiveShell();
                    boolean isIDE = CommonUIUtils.isIDEEnvironment();
                    if (isIDE) {
                        SaveAsDialog dialog = new SaveAsDialog(shell);
                        if (dialog.open() != 0) {
                            return false;
                        }
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(dialog.getResult());
                        try {
                            if (!file.exists()) {
                                file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
                            }
                            file.setContents((InputStream)new ByteArrayInputStream(ldif.toString().getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    boolean canOverwrite = false;
                    String path = null;
                    block12: while (!canOverwrite) {
                        FileDialog dialog = new FileDialog(shell, 8192);
                        path = dialog.open();
                        if (path == null) {
                            return false;
                        }
                        File externalFile = new File(path);
                        if (externalFile.exists()) {
                            String question = NLS.bind((String)Messages.getString("BatchOperationWizard.TheFileAlreadyExistsReplace"), (Object)path);
                            MessageDialog overwriteDialog = new MessageDialog(shell, Messages.getString("BatchOperationWizard.Question"), null, question, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                            int overwrite = overwriteDialog.open();
                            switch (overwrite) {
                                case 0: {
                                    canOverwrite = true;
                                    continue block12;
                                }
                                case 1: {
                                    continue block12;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                        canOverwrite = true;
                    }
                    try {
                        BufferedWriter outFile = new BufferedWriter(new FileWriter(path));
                        outFile.write(ldif.toString());
                        outFile.close();
                    }
                    catch (Exception exception) {
                        return false;
                    }
                    return true;
                }
                if (this.finishPage.getExecutionMethod() == 3) {
                    CopyAction.copyToClipboard((Object[])new Object[]{ldif.toString()}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
                    return true;
                }
                if (this.finishPage.getExecutionMethod() == 0) {
                    ExecuteLdifRunnable runnable = new ExecuteLdifRunnable(this.getConnection(), ldif.toString(), true, this.finishPage.getContinueOnError());
                    StudioBrowserJob job = new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{runnable});
                    job.execute();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public BatchOperationTypeWizardPage getTypePage() {
        return this.typePage;
    }

    public IBrowserConnection getConnection() {
        return this.connection;
    }

    class DummyWizardPage
    extends WizardPage {
        protected DummyWizardPage() {
            super("");
            super.setTitle(Messages.getString("BatchOperationWizard.NoConnectionSelected"));
            super.setDescription(Messages.getString("BatchOperationWizard.SelectOpenConnection"));
            super.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            composite.setLayout((Layout)gl);
            composite.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)composite);
        }
    }
}

