/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObjectSorter;
import org.apache.directory.api.ldap.schema.converter.AttributeTypeHolder;
import org.apache.directory.api.ldap.schema.converter.ObjectClassHolder;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.wizards.ExportSchemasForADSWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportSchemasForADSWizard
extends Wizard
implements IExportWizard {
    private Schema[] selectedSchemas = new Schema[0];
    private ExportSchemasForADSWizardPage page;

    public void addPages() {
        this.page = new ExportSchemasForADSWizardPage();
        this.page.setSelectedSchemas(this.selectedSchemas);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        final Schema[] selectedSchemas = this.page.getSelectedSchemas();
        int exportType = this.page.getExportType();
        if (exportType == 0) {
            final String exportDirectory = this.page.getExportDirectory();
            try {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString("ExportSchemasForADSWizard.ExportingSchemas"), selectedSchemas.length);
                        Schema[] schemaArray = selectedSchemas;
                        int n = selectedSchemas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Schema schema = schemaArray[n2];
                            monitor.subTask(schema.getSchemaName());
                            StringBuffer sb = new StringBuffer();
                            DateFormat format = DateFormat.getDateTimeInstance(1, 2);
                            Date date = new Date();
                            sb.append(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.GeneratedByApacheComment"), (Object[])new String[]{format.format(date)}));
                            try {
                                ExportSchemasForADSWizard.this.toLdif(schema, sb);
                                BufferedWriter buffWriter = new BufferedWriter(new FileWriter(String.valueOf(exportDirectory) + "/" + schema.getSchemaName() + ".ldif"));
                                buffWriter.write(sb.toString());
                                buffWriter.close();
                            }
                            catch (Exception e) {
                                PluginUtils.logError(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getSchemaName()}), e);
                                ViewUtils.displayErrorMessageDialog(Messages.getString("ExportSchemasForADSWizard.Error"), NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getSchemaName()}));
                            }
                            monitor.worked(1);
                            ++n2;
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (exportType == 1) {
            final String exportFile = this.page.getExportFile();
            try {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString("ExportSchemasForADSWizard.ExportingSchemas"), 1);
                        StringBuffer sb = new StringBuffer();
                        DateFormat format = DateFormat.getDateTimeInstance(1, 2);
                        Date date = new Date();
                        sb.append(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.GeneratedByApacheComment"), (Object[])new String[]{format.format(date)}));
                        Schema[] schemaArray = selectedSchemas;
                        int n = selectedSchemas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Schema schema = schemaArray[n2];
                            try {
                                ExportSchemasForADSWizard.this.toLdif(schema, sb);
                            }
                            catch (Exception e) {
                                PluginUtils.logError(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getSchemaName()}), e);
                                ViewUtils.displayErrorMessageDialog(Messages.getString("ExportSchemasForADSWizard.Error"), NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchema"), (Object[])new String[]{schema.getSchemaName()}));
                            }
                            ++n2;
                        }
                        try {
                            BufferedWriter buffWriter = new BufferedWriter(new FileWriter(exportFile));
                            buffWriter.write(sb.toString());
                            buffWriter.close();
                        }
                        catch (IOException e) {
                            PluginUtils.logError(Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchemas"), e);
                            ViewUtils.displayErrorMessageDialog(Messages.getString("ExportSchemasForADSWizard.Error"), Messages.getString("ExportSchemasForADSWizard.ErrorSavingSchemas"));
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    private void toLdif(Schema schema, StringBuffer sb) throws LdapException {
        String[] schemaDependencies;
        sb.append(NLS.bind((String)Messages.getString("ExportSchemasForADSWizard.SchemaComment"), (Object[])new String[]{schema.getSchemaName().toUpperCase()}));
        sb.append("dn: cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: metaSchema\n");
        sb.append("objectclass: top\n");
        sb.append("cn: " + schema.getSchemaName() + "\n");
        String[] stringArray = schemaDependencies = this.getSchemaDependencies(schema);
        int n = schemaDependencies.length;
        int n2 = 0;
        while (n2 < n) {
            String schemaName = stringArray[n2];
            sb.append("m-dependencies: " + schemaName + "\n");
            ++n2;
        }
        sb.append("\n");
        sb.append("dn: ou=attributetypes, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: attributetypes\n");
        sb.append("\n");
        for (AttributeType at : schema.getAttributeTypes()) {
            AttributeTypeHolder holder = new AttributeTypeHolder(at.getOid());
            holder.setCollective(at.isCollective());
            holder.setDescription(at.getDescription());
            holder.setEquality(at.getEqualityOid());
            ArrayList<String> names = new ArrayList<String>();
            for (String name : at.getNames()) {
                names.add(name);
            }
            holder.setNames(names);
            holder.setNoUserModification(!at.isUserModifiable());
            holder.setObsolete(at.isObsolete());
            holder.setOrdering(at.getOrderingOid());
            holder.setSingleValue(at.isSingleValued());
            holder.setSubstr(at.getSubstringOid());
            holder.setSuperior(at.getSuperiorOid());
            holder.setSyntax(at.getSyntaxOid());
            if (at.getSyntaxLength() > 0L) {
                holder.setOidLen(at.getSyntaxLength());
            }
            holder.setUsage(at.getUsage());
            sb.append(String.valueOf(holder.toLdif(schema.getSchemaName())) + "\n");
        }
        sb.append("dn: ou=comparators, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: comparators\n");
        sb.append("\n");
        sb.append("dn: ou=ditcontentrules, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: ditcontentrules\n");
        sb.append("\n");
        sb.append("dn: ou=ditstructurerules, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: ditstructurerules\n");
        sb.append("\n");
        sb.append("dn: ou=matchingrules, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: matchingrules\n");
        sb.append("\n");
        sb.append("dn: ou=matchingruleuse, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: matchingruleuse\n");
        sb.append("\n");
        sb.append("dn: ou=nameforms, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: nameforms\n");
        sb.append("\n");
        sb.append("dn: ou=normalizers, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: normalizers\n");
        sb.append("\n");
        sb.append("dn: ou=objectclasses, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: objectClasses\n");
        sb.append("\n");
        Iterable sortedObjectClasses = SchemaObjectSorter.sortObjectClasses(schema.getObjectClasses());
        for (ObjectClass oc : sortedObjectClasses) {
            ObjectClassHolder holder = new ObjectClassHolder(oc.getOid());
            holder.setClassType(oc.getType());
            holder.setDescription(oc.getDescription());
            ArrayList<String> mayList = new ArrayList<String>();
            for (String may : oc.getMayAttributeTypeOids()) {
                mayList.add(may);
            }
            holder.setMay(mayList);
            ArrayList<String> mustList = new ArrayList<String>();
            for (String must : oc.getMustAttributeTypeOids()) {
                mustList.add(must);
            }
            holder.setMust(mustList);
            ArrayList<String> names = new ArrayList<String>();
            for (String name : oc.getNames()) {
                names.add(name);
            }
            holder.setNames(names);
            ArrayList<String> superiorList = new ArrayList<String>();
            for (String superior : oc.getSuperiorOids()) {
                superiorList.add(superior);
            }
            holder.setSuperiors(superiorList);
            holder.setObsolete(oc.isObsolete());
            sb.append(String.valueOf(holder.toLdif(schema.getSchemaName())) + "\n");
        }
        sb.append("dn: ou=syntaxcheckers, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: syntaxcheckers\n");
        sb.append("\n");
        sb.append("dn: ou=syntaxes, cn=" + Rdn.escapeValue((String)schema.getSchemaName()) + ", ou=schema\n");
        sb.append("objectclass: organizationalUnit\n");
        sb.append("objectclass: top\n");
        sb.append("ou: syntaxes\n");
        sb.append("\n");
    }

    private String[] getSchemaDependencies(Schema schema) {
        HashSet<String> schemaNames = new HashSet<String>();
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        for (AttributeType at : schema.getAttributeTypes()) {
            AttributeType sup;
            String supName = at.getSuperiorOid();
            if (supName == null || (sup = schemaHandler.getAttributeType(supName)) == null || Strings.toLowerCase((String)schema.getSchemaName()).equals(Strings.toLowerCase((String)sup.getSchemaName()))) continue;
            schemaNames.add(sup.getSchemaName());
        }
        for (ObjectClass oc : schema.getObjectClasses()) {
            List mustNames;
            List mayNames;
            List supNames = oc.getSuperiorOids();
            if (supNames != null) {
                for (String supName : oc.getSuperiorOids()) {
                    ObjectClass sup = schemaHandler.getObjectClass(supName);
                    if (sup == null || Strings.toLowerCase((String)schema.getSchemaName()).equals(Strings.toLowerCase((String)sup.getSchemaName()))) continue;
                    schemaNames.add(sup.getSchemaName());
                }
            }
            if ((mayNames = oc.getMayAttributeTypeOids()) != null) {
                for (String mayName : mayNames) {
                    AttributeType may = schemaHandler.getAttributeType(mayName);
                    if (may == null || Strings.toLowerCase((String)schema.getSchemaName()).equals(Strings.toLowerCase((String)may.getSchemaName()))) continue;
                    schemaNames.add(may.getSchemaName());
                }
            }
            if ((mustNames = oc.getMustAttributeTypeOids()) == null) continue;
            for (String mustName : oc.getMustAttributeTypeOids()) {
                AttributeType must = schemaHandler.getAttributeType(mustName);
                if (must == null || Strings.toLowerCase((String)schema.getSchemaName()).equals(Strings.toLowerCase((String)must.getSchemaName()))) continue;
                schemaNames.add(must.getSchemaName());
            }
        }
        return schemaNames.toArray(new String[0]);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    public void setSelectedSchemas(Schema[] schemas) {
        this.selectedSchemas = schemas;
    }
}

