/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.schema;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.schema.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorTableViewerContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorTableViewerLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class SchemaEditorOverviewPage
extends FormPage {
    public static final String ID = String.valueOf(SchemaEditor.ID) + "overviewPage";
    private Schema originalSchema;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        @Override
        public void attributeTypeAdded(AttributeType at) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void attributeTypeModified(AttributeType at) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void attributeTypeRemoved(AttributeType at) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void matchingRuleAdded(MatchingRule mr) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void matchingRuleModified(MatchingRule mr) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void matchingRuleRemoved(MatchingRule mr) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassAdded(ObjectClass oc) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassModified(ObjectClass oc) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void objectClassRemoved(ObjectClass oc) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void schemaAdded(Schema schema) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void schemaRemoved(Schema schema) {
            if (!((Object)((Object)schema)).equals((Object)SchemaEditorOverviewPage.this.originalSchema)) {
                SchemaEditorOverviewPage.this.refreshUI();
            }
        }

        @Override
        public void schemaRenamed(Schema schema) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxAdded(LdapSyntax syntax) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxModified(LdapSyntax syntax) {
            SchemaEditorOverviewPage.this.refreshUI();
        }

        @Override
        public void syntaxRemoved(LdapSyntax syntax) {
            SchemaEditorOverviewPage.this.refreshUI();
        }
    };
    private Section attributeTypesSection;
    private TableViewer attributeTypesTableViewer;
    private Section objectClassesSection;
    private TableViewer objectClassesTableViewer;
    private IDoubleClickListener attributeTypesTableViewerListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                AttributeType at = (AttributeType)selection.getFirstElement();
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new AttributeTypeEditorInput(at), AttributeTypeEditor.ID);
                }
                catch (PartInitException exception) {
                    PluginUtils.logError(Messages.getString("SchemaEditorOverviewPage.ErrorOpenEditor"), exception);
                    ViewUtils.displayErrorMessageDialog(Messages.getString("SchemaEditorOverviewPage.Error"), Messages.getString("SchemaEditorOverviewPage.ErrorOpenEditor"));
                }
            }
        }
    };
    private IDoubleClickListener objectClassesTableViewerListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                ObjectClass oc = (ObjectClass)selection.getFirstElement();
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new ObjectClassEditorInput(oc), ObjectClassEditor.ID);
                }
                catch (PartInitException exception) {
                    PluginUtils.logError(Messages.getString("SchemaEditorOverviewPage.ErrorOpenEditor"), exception);
                    ViewUtils.displayErrorMessageDialog(Messages.getString("SchemaEditorOverviewPage.Error"), Messages.getString("SchemaEditorOverviewPage.ErrorOpenEditor"));
                }
            }
        }
    };

    public SchemaEditorOverviewPage(FormEditor editor) {
        super(editor, ID, Messages.getString("SchemaEditorOverviewPage.Overview"));
        Activator.getDefault().getSchemaHandler().addListener(this.schemaHandlerListener);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.originalSchema = ((SchemaEditor)this.getEditor()).getSchema();
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout(2, true);
        form.getBody().setLayout((Layout)layout);
        this.createAttributeTypesSection(form.getBody(), toolkit);
        this.createObjectClassesSection(form.getBody(), toolkit);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, String.valueOf(PluginConstants.PLUGIN_ID) + "." + "schema_editor");
    }

    private void createAttributeTypesSection(Composite parent, FormToolkit toolkit) {
        this.attributeTypesSection = toolkit.createSection(parent, 448);
        this.attributeTypesSection.setDescription("");
        this.attributeTypesSection.setText(Messages.getString("SchemaEditorOverviewPage.AttributeTypes"));
        Composite attributeTypesSectionClient = toolkit.createComposite((Composite)this.attributeTypesSection);
        attributeTypesSectionClient.setLayout((Layout)new GridLayout());
        toolkit.paintBordersFor(attributeTypesSectionClient);
        this.attributeTypesSection.setClient((Control)attributeTypesSectionClient);
        this.attributeTypesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.attributeTypesTableViewer = new TableViewer(attributeTypesSectionClient, 2820);
        this.attributeTypesTableViewer.setContentProvider((IContentProvider)new SchemaEditorTableViewerContentProvider());
        this.attributeTypesTableViewer.setLabelProvider((IBaseLabelProvider)new SchemaEditorTableViewerLabelProvider());
        this.attributeTypesTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createObjectClassesSection(Composite parent, FormToolkit toolkit) {
        this.objectClassesSection = toolkit.createSection(parent, 448);
        this.objectClassesSection.setDescription("");
        this.objectClassesSection.setText(Messages.getString("SchemaEditorOverviewPage.ObjectClasses"));
        Composite objectClassesSectionClient = toolkit.createComposite((Composite)this.objectClassesSection);
        objectClassesSectionClient.setLayout((Layout)new GridLayout());
        toolkit.paintBordersFor(objectClassesSectionClient);
        this.objectClassesSection.setClient((Control)objectClassesSectionClient);
        this.objectClassesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.objectClassesTableViewer = new TableViewer(objectClassesSectionClient, 2820);
        this.objectClassesTableViewer.setContentProvider((IContentProvider)new SchemaEditorTableViewerContentProvider());
        this.objectClassesTableViewer.setLabelProvider((IBaseLabelProvider)new SchemaEditorTableViewerLabelProvider());
        this.objectClassesTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void fillInUiFields() {
        this.attributeTypesSection.setDescription(NLS.bind((String)Messages.getString("SchemaEditorOverviewPage.SchemaAttribute"), (Object[])new String[]{this.originalSchema.getSchemaName()}));
        this.objectClassesSection.setDescription(NLS.bind((String)Messages.getString("SchemaEditorOverviewPage.SchemaObjectClasses"), (Object[])new String[]{this.originalSchema.getSchemaName()}));
        this.attributeTypesTableViewer.setInput(this.originalSchema.getAttributeTypes());
        this.objectClassesTableViewer.setInput(this.originalSchema.getObjectClasses());
    }

    private void addListeners() {
        this.attributeTypesTableViewer.addDoubleClickListener(this.attributeTypesTableViewerListener);
        this.objectClassesTableViewer.addDoubleClickListener(this.objectClassesTableViewerListener);
    }

    private void removeListeners() {
        this.attributeTypesTableViewer.removeDoubleClickListener(this.attributeTypesTableViewerListener);
        this.objectClassesTableViewer.removeDoubleClickListener(this.objectClassesTableViewerListener);
    }

    public void dispose() {
        this.removeListeners();
        Activator.getDefault().getSchemaHandler().removeListener(this.schemaHandlerListener);
        super.dispose();
    }

    public void refreshUI() {
        this.removeListeners();
        this.fillInUiFields();
        this.addListeners();
    }
}

