/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportCsvRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.core.runtime.Preferences;

public class ExportXlsRunnable
implements StudioConnectionRunnableWithProgress {
    public static final int MAX_COUNT_LIMIT = 65000;
    private String exportXlsFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;
    private boolean exportDn;

    public ExportXlsRunnable(String exportLdifFilename, IBrowserConnection browserConnection, SearchParameter searchParameter, boolean exportDn) {
        this.exportXlsFilename = exportLdifFilename;
        this.browserConnection = browserConnection;
        this.searchParameter = searchParameter;
        this.exportDn = exportDn;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__export_xls_name;
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportXlsFilename)};
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_xls_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_xls_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
        String valueDelimiter = coreStore.getString("formatXlsValueDelimiter");
        int binaryEncoding = coreStore.getInt("formatXlsBinaryEncoding");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("Export");
        HSSFRow headerRow = sheet.createRow(0);
        LinkedHashMap<String, Integer> attributeNameMap = new LinkedHashMap<String, Integer>();
        if (this.exportDn) {
            int cellNum = 0;
            attributeNameMap.put("dn", cellNum);
            ExportXlsRunnable.createStringCell(headerRow, cellNum).setCellValue("dn");
        }
        if (this.searchParameter.getCountLimit() < 1 || this.searchParameter.getCountLimit() > 65000) {
            this.searchParameter.setCountLimit(65000);
        }
        try {
            int count = 0;
            ExportXlsRunnable.exportToXls(this.browserConnection, this.searchParameter, sheet, headerRow, count, monitor, attributeNameMap, valueDelimiter, binaryEncoding, this.exportDn);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        int i = 0;
        while (i <= sheet.getLastRowNum()) {
            HSSFRow row = sheet.getRow(i);
            short j = 0;
            while (row != null && j <= row.getLastCellNum()) {
                String value;
                HSSFCell cell = row.getCell(j);
                if (cell != null && cell.getCellType() == 1 && (short)((double)((value = cell.getStringCellValue()).length() * 256) * 1.1) > sheet.getColumnWidth(j)) {
                    sheet.setColumnWidth(j, (short)((double)(value.length() * 256) * 1.1));
                }
                j = (short)(j + 1);
            }
            ++i;
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(this.exportXlsFilename);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private static void exportToXls(IBrowserConnection browserConnection, SearchParameter searchParameter, HSSFSheet sheet, HSSFRow headerRow, int count, StudioProgressMonitor monitor, LinkedHashMap<String, Integer> attributeNameMap, String valueDelimiter, int binaryEncoding, boolean exportDn) throws IOException {
        block3: {
            try {
                LdifEnumeration enumeration = ExportLdifRunnable.search(browserConnection, searchParameter, monitor);
                while (!monitor.isCanceled() && !monitor.errorsReported() && enumeration.hasNext()) {
                    LdifContainer container = enumeration.next();
                    if (!(container instanceof LdifContentRecord)) continue;
                    LdifContentRecord record = (LdifContentRecord)container;
                    ExportXlsRunnable.recordToHSSFRow(browserConnection, record, sheet, headerRow, attributeNameMap, valueDelimiter, binaryEncoding, exportDn);
                    monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
                }
            }
            catch (LdapException ne) {
                int ldapStatusCode = JNDIUtils.getLdapStatusCode((Exception)((Object)ne));
                if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) break block3;
                monitor.reportError((Exception)((Object)ne));
            }
        }
    }

    private static void recordToHSSFRow(IBrowserConnection browserConnection, LdifContentRecord record, HSSFSheet sheet, HSSFRow headerRow, Map<String, Integer> headerRowAttributeNameMap, String valueDelimiter, int binaryEncoding, boolean exportDn) {
        Map<String, String> attributeMap = ExportCsvRunnable.getAttributeMap(null, record, valueDelimiter, "UTF-16", binaryEncoding);
        HSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
        if (exportDn) {
            HSSFCell cell = ExportXlsRunnable.createStringCell(row, 0);
            cell.setCellValue(record.getDnLine().getValueAsString());
        }
        for (String attributeName : attributeMap.keySet()) {
            HSSFCell cell;
            int cellNum;
            String value = attributeMap.get(attributeName);
            if (!headerRowAttributeNameMap.containsKey(attributeName)) {
                cellNum = headerRowAttributeNameMap.size();
                headerRowAttributeNameMap.put(attributeName, new Integer(cellNum));
                cell = ExportXlsRunnable.createStringCell(headerRow, cellNum);
                cell.setCellValue(attributeName);
            }
            if (!headerRowAttributeNameMap.containsKey(attributeName)) continue;
            cellNum = headerRowAttributeNameMap.get(attributeName).shortValue();
            cell = ExportXlsRunnable.createStringCell(row, cellNum);
            cell.setCellValue(value);
        }
    }

    private static HSSFCell createStringCell(HSSFRow row, int cellNum) {
        HSSFCell cell = row.createCell(cellNum);
        cell.setCellType(1);
        return cell;
    }
}

