/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.ldap.model.message.Request;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BatchRequestDsml {
    private List<DsmlDecorator<? extends Request>> requests = new ArrayList<DsmlDecorator<? extends Request>>();
    private int requestID;
    private Processing processing;
    private OnError onError;
    private ResponseOrder responseOrder = ResponseOrder.SEQUENTIAL;
    private boolean storeReq = true;
    private DsmlDecorator<? extends Request> currentReq;

    public BatchRequestDsml() {
        this.processing = Processing.SEQUENTIAL;
        this.onError = OnError.EXIT;
    }

    public DsmlDecorator<? extends Request> getCurrentRequest() {
        return this.currentReq;
    }

    public boolean addRequest(DsmlDecorator<? extends Request> request) {
        this.currentReq = request;
        if (this.storeReq) {
            return this.requests.add(request);
        }
        return true;
    }

    public boolean removeRequest(DsmlDecorator<? extends Request> request) {
        return this.requests.remove(request);
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public Processing getProcessing() {
        return this.processing;
    }

    public void setProcessing(Processing processing) {
        this.processing = processing;
    }

    public OnError getOnError() {
        return this.onError;
    }

    public void setOnError(OnError onError) {
        this.onError = onError;
    }

    public ResponseOrder getResponseOrder() {
        return this.responseOrder;
    }

    public void setResponseOrder(ResponseOrder responseOrder) {
        this.responseOrder = responseOrder;
    }

    public List<DsmlDecorator<? extends Request>> getRequests() {
        return this.requests;
    }

    public String toDsml() {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("batchRequest");
        if (this.requestID != 0) {
            element.addAttribute("requestID", Integer.toString(this.requestID));
        }
        if (this.responseOrder == ResponseOrder.UNORDERED) {
            element.addAttribute("responseOrder", "unordered");
        }
        if (this.processing == Processing.PARALLEL) {
            element.addAttribute("processing", "parallel");
        }
        if (this.onError == OnError.RESUME) {
            element.addAttribute("onError", "resume");
        }
        for (DsmlDecorator<? extends Request> request : this.requests) {
            request.toDsml(element);
        }
        return ParserUtils.styleDocument(document).asXML();
    }

    public boolean isStoringRequests() {
        return this.storeReq;
    }

    public void setStoreReq(boolean storeReq) {
        this.storeReq = storeReq;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("processing: ").append((Object)this.processing);
        sb.append(" - ");
        sb.append("onError: ").append((Object)this.onError);
        sb.append(" - ");
        sb.append("responseOrder: ").append((Object)this.responseOrder);
        sb.append("]");
        return sb.toString();
    }

    public static enum ResponseOrder {
        SEQUENTIAL,
        UNORDERED;

    }

    public static enum OnError {
        RESUME,
        EXIT;

    }

    public static enum Processing {
        SEQUENTIAL,
        PARALLEL;

    }
}

