/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.merge.EolAwareOutputStream;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeResult;

class MergeFormatterPass {
    private final EolAwareOutputStream out;
    private final MergeResult<RawText> res;
    private final List<String> seqName;
    private final Charset charset;
    private final boolean threeWayMerge;
    private final boolean writeBase;
    private String lastConflictingName;

    MergeFormatterPass(OutputStream out, MergeResult<RawText> res, List<String> seqName, Charset charset) {
        this(out, res, seqName, charset, false);
    }

    MergeFormatterPass(OutputStream out, MergeResult<RawText> res, List<String> seqName, Charset charset, boolean writeBase) {
        this.out = new EolAwareOutputStream(out);
        this.res = res;
        this.seqName = seqName;
        this.charset = charset;
        this.threeWayMerge = res.getSequences().size() == 3;
        this.writeBase = writeBase;
    }

    void formatMerge() throws IOException {
        boolean missingNewlineAtEnd = false;
        for (MergeChunk chunk : this.res) {
            if (this.isBase(chunk) && !this.writeBase) continue;
            RawText seq = this.res.getSequences().get(chunk.getSequenceIndex());
            this.writeConflictMetadata(chunk);
            int i = chunk.getBegin();
            while (i < chunk.getEnd()) {
                this.writeLine(seq, i);
                ++i;
            }
            missingNewlineAtEnd = seq.isMissingNewlineAtEnd();
        }
        if (this.lastConflictingName != null) {
            this.writeConflictEnd();
        }
        if (!missingNewlineAtEnd) {
            this.out.beginln();
        }
    }

    private void writeConflictMetadata(MergeChunk chunk) throws IOException {
        if (this.lastConflictingName != null && !this.isTheirs(chunk) && !this.isBase(chunk)) {
            this.writeConflictEnd();
        }
        if (this.isOurs(chunk)) {
            this.writeConflictStart(chunk);
        } else if (this.isTheirs(chunk)) {
            this.writeConflictChange(chunk);
        } else if (this.isBase(chunk)) {
            this.writeConflictBase(chunk);
        }
    }

    private void writeConflictEnd() throws IOException {
        this.writeln(">>>>>>> " + this.lastConflictingName);
        this.lastConflictingName = null;
    }

    private void writeConflictStart(MergeChunk chunk) throws IOException {
        this.lastConflictingName = this.seqName.get(chunk.getSequenceIndex());
        this.writeln("<<<<<<< " + this.lastConflictingName);
    }

    private void writeConflictChange(MergeChunk chunk) throws IOException {
        this.lastConflictingName = this.seqName.get(chunk.getSequenceIndex());
        this.writeln(this.threeWayMerge ? "=======" : "======= " + this.lastConflictingName);
    }

    private void writeConflictBase(MergeChunk chunk) throws IOException {
        this.lastConflictingName = this.seqName.get(chunk.getSequenceIndex());
        this.writeln("||||||| " + this.lastConflictingName);
    }

    private void writeln(String s) throws IOException {
        this.out.beginln();
        this.out.write((String.valueOf(s) + "\n").getBytes(this.charset));
    }

    private void writeLine(RawText seq, int i) throws IOException {
        this.out.beginln();
        seq.writeLine(this.out, i);
        if (this.out.isBeginln()) {
            this.out.write(10);
        }
    }

    private boolean isBase(MergeChunk chunk) {
        return chunk.getConflictState() == MergeChunk.ConflictState.BASE_CONFLICTING_RANGE;
    }

    private boolean isOurs(MergeChunk chunk) {
        return chunk.getConflictState() == MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE;
    }

    private boolean isTheirs(MergeChunk chunk) {
        return chunk.getConflictState() == MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE;
    }
}

