/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.controller.Loglevel;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.configuration.option.OptionsConfiguration;
import org.apache.torque.generator.configuration.source.EntityReferences;

public class ControlConfiguration {
    private List<Output> outputList = new ArrayList<Output>();
    private List<OptionsConfiguration> optionsConfigurations = new ArrayList<OptionsConfiguration>();
    private EntityReferences entityReferences = new EntityReferences();
    private Loglevel loglevel = Loglevel.INFO;

    void addOutput(Output output) throws ConfigurationException {
        if (output == null) {
            throw new NullPointerException("output must not be null");
        }
        for (Output existing : this.outputList) {
            if (!existing.getName().equals(output.getName())) continue;
            throw new ConfigurationException("Output with name " + output.getName() + " already exists");
        }
        this.outputList.add(output);
    }

    public List<Output> getOutputFiles() {
        return Collections.unmodifiableList(this.outputList);
    }

    void addOptionsConfiguration(OptionsConfiguration optionsConfiguration) {
        if (optionsConfiguration == null) {
            throw new NullPointerException("optionsConfiguration is null");
        }
        this.optionsConfigurations.add(optionsConfiguration);
    }

    public List<OptionsConfiguration> getOptionsConfigurations() {
        return Collections.unmodifiableList(this.optionsConfigurations);
    }

    public EntityReferences getEntityReferences() {
        return this.entityReferences;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(outputFiles=").append(this.outputList.toString()).append(", optionsConfigurations=").append(this.optionsConfigurations.toString()).append(")");
        return result.toString();
    }

    public Loglevel getLoglevel() {
        return this.loglevel;
    }

    public void setLoglevel(Loglevel loglevel) {
        if (loglevel == null) {
            throw new NullPointerException("loglevel is null");
        }
        this.loglevel = loglevel;
    }
}

