/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.processor.string;

import org.apache.torque.generator.processor.string.CharReplacer;

public class ConstantNameCreator
extends CharReplacer {
    public static final String UPPER_CASE_SEPPARATION_PREFIX = "_";
    private String upperCaseSeparationPrefix = "_";

    public ConstantNameCreator() {
        this.setToReplace("-.;,\"'#+*`\u00c2\u00b4~_");
    }

    public String getUpperCaseSeparationPrefix() {
        return this.upperCaseSeparationPrefix;
    }

    public void setUpperCaseSeparationPrefix(String upperCaseSeparationPrefix) {
        this.upperCaseSeparationPrefix = upperCaseSeparationPrefix;
    }

    public String process(String toProcess) {
        StringBuilder result = new StringBuilder();
        String toReplace = this.getToReplace();
        String toReplaceWith = this.getToReplaceWith();
        boolean lastCharWasSpecial = true;
        boolean lastCharWasLowerCase = false;
        for (int i = 0; i < toProcess.length(); ++i) {
            boolean specialChar;
            char currentChar = toProcess.charAt(i);
            boolean bl = specialChar = toReplace.indexOf(currentChar) != -1;
            if (specialChar) {
                if (lastCharWasSpecial) continue;
                result.append(toReplaceWith);
                lastCharWasLowerCase = false;
            } else if (Character.isUpperCase(currentChar)) {
                if (lastCharWasSpecial || !lastCharWasLowerCase) {
                    result.append(currentChar);
                } else {
                    result.append(this.upperCaseSeparationPrefix).append(currentChar);
                }
                lastCharWasLowerCase = false;
            } else {
                result.append(Character.toUpperCase(currentChar));
                lastCharWasLowerCase = true;
            }
            lastCharWasSpecial = specialChar;
        }
        return result.toString();
    }
}

